<?php
/*******************************************
 Database query to get poll info
 *******************************************/
// get vote from form
$vote=$_POST['vote'];
$host = 'localhost'; // Change as necessary
$data = 'polling'; // Change as necessary
$user = 'root'; // Change as necessary
$pass = 'mysql'; // Change as necessary
$chrs = 'utf8mb4';
$attr = "mysql:host=$host;dbname=$data;charset=$chrs";
$opts =
[
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
];
try
{
    $pdo = new PDO($attr, $user, $pass, $opts);
}
catch (PDOException $e)
{
    throw new PDOException($e->getMessage(), (int)$e->getCode());
}
if (!empty($vote))  // if they filled the form out, add their vote
{
    $vote = addslashes($vote);
    $query = "update poll_results
            set num_votes = num_votes + 1
            where candidate = '$vote'";
    $result = $pdo->query($query);
    if(!$result)
    {
        echo 'Could not connect to db<br />';
        exit;
    }
}
// get current results of poll, regardless of whether they voted
$query = 'select * from poll_results';
$result = $pdo->query($query);
if(!$result) {
    echo 'Could not connect to db<br />';
    exit;
}
$total_votes = 0;
while ($row = $result->fetch()) {
    $total_votes +=  $row['num_votes'];
}
$num_candidates = $result->rowCount();
/*******************************************
 Initial calculations for graph
 *******************************************/
// set up constants
$width=500;        // width of image in pixels - this will fit in 640x480
$left_margin = 50; // space to leave on left of image
$right_margin= 50; // ditto right
$bar_height = 40;
$bar_spacing = $bar_height/2;
$title_size= 16; // point
$main_size= 12; // point
$small_size= 12; // point
$text_indent = 10; // position for text labels on left
// set up initial point to draw from
$x = $left_margin + 60;  // place to draw baseline of the graph
$y = 50;		  // ditto
$bar_unit = ($width-($x+$right_margin)) / 100;   // one "point" on the graph
// calculate height of graph - bars plus gaps plus some margin
$height = $num_candidates * ($bar_height + $bar_spacing) + 50;
/*******************************************
 Set up base image
 *******************************************/
// create a blank canvas
$im = imagecreatetruecolor($width,$height);
// Allocate colors
$white=imagecolorallocate($im,255,255,255);
$blue=imagecolorallocate($im,0,64,128);
$black=imagecolorallocate($im,0,0,0);
$red = imagecolorallocate($im,255,0,0);
$bar_color = $red;
$text_color = $black;
$line_color = $white;
$bar_color = $blue;
// Create "canvas" to draw on
imagefill($im, 0, 0, $white);
// Add title
$title = 'Poll Results';
imagestring($im, $title_size, 10, 10,  $title, $text_color);
/*******************************************
 Draw data into graph
 *******************************************/
$query = 'select * from poll_results';
$result = $pdo->query($query);
while ($row = $result->fetch()) 
{
    if ($total_votes > 0)
        $percent = intval(round(($row['num_votes']/$total_votes)*100));
    else
        $percent = 0;
    // display percent for this value
    imagestring($im, $main_size,  $width-30, $y+($bar_height/2),  $percent.'%',  $black);
    if ($total_votes > 0)
         $right_value = intval(round(($row['num_votes'] / $total_votes)*100));
    else
         $right_value = 0;
    $bar_length = $x + ($right_value * $bar_unit);
    // draw bar for this value
    imagefilledrectangle($im, $x, $y-2, $bar_length, $y+$bar_height, $bar_color);
    // draw title for this value
    $ca = $row['candidate'];
    imagestring($im, $main_size,  $text_indent, $y+($bar_height/2),    $ca, $text_color);
    // draw outline showing 100%
    imagerectangle($im, $bar_length+1, $y-2,  ($x+(100*$bar_unit)), $y+$bar_height, $line_color);
    // display numbers
    $num = $row['num_votes'];
    imagestring($im, $small_size, $x+(100*$bar_unit)-50, $y+($bar_height/2), $num.'/'.$total_votes, $red);
   // move down to next bar
    $y = $y + ($bar_height+$bar_spacing);
}
/*******************************************
 Display image
 *******************************************/
header('Content-type:  image/png');//
imagepng($im);
/*******************************************
 Clean up
 *******************************************/
imagedestroy($im);
?>


