public class OuterClass 
{
    //create an array
    private final static int SIZE = 15;
    private int[] arrayOfInts = new int[SIZE];
    
    public OuterClass()
    {
        //fill the array with ascending integer values
        for (int i = 0; i < SIZE; i++)
        {
                arrayOfInts[i] = i;
        }
    }
    
    public void printEven()
    {
        //print out values of even indices of the array
      //  InnerClass iterator = this.new InnerClass();
        InnerClass iterator = new InnerClass();
        while (iterator.hasNext())
        {
            System.out.print(iterator.getNext() + " ");
        }
    }
    
//inner class implements the Iterator pattern
    private class InnerClass
    {
        //start stepping through the array from the beginning
        private int next = 0;
        
        public boolean hasNext()
        {
            //check if a current element is the last in the array
            return (next <= SIZE - 1);
        }
        
        public int getNext()
        {
            //record a value of an even index of the array
            int retValue = arrayOfInts[next];
            //get the next even element
            next += 2;
            return retValue;
        }
    }
}
