import java.util.*;
public class Exam {
	  static Scanner console = new Scanner(System.in);
	  //*** data fields
	  private float[] scores;
	  //*** Methods
	  public void getExamData() throws Exception
	  {
	     System.out.print("How many students took the exam?");
	     scores = new float[console.nextInt()];
	     for(int i = 0; i < scores.length; i ++)
	     {
	        System.out.print("Score for student " + (i+1)+":");
	        scores[i] = console.nextFloat();
	     }
	  }
	  //***
	   public void showStats()
	   {
	        if (scores.length > 0)
	        {
	           System.out.println("--------------------");
	           System.out.println("Students" + "\t" + "Scores");
	           for(int i = 0; i <scores.length; i++)
	             System.out.println((i+1) + "\t\t" + scores[i]);
	           System.out.println("--------------------");
	           System.out.println("Minimum score is:" + findMin());
	           System.out.println("Maximum score is:" + findMax());
	           double mean = computeMean(); //save in men to standard deviation
	           System.out.println("Mean score is:" + mean) ;
	           System.out.println("Standard deviation is:" + computeStandardDev(mean));
	         }
	        else
	            System.out.println("No studententered, so no stats!");
	   }
	     //****
	   public float findMin()
	   {
	        float minScore = scores[0];
	        for(int i = 0; i < scores.length; i ++)
	           if (scores[i] < minScore)
	              minScore = scores[i];
	        return minScore;
	   }
	   //****
	   public float findMax()
	   {
	        float maxScore = scores[0];
	        for(int i = 0; i < scores.length; i ++)
	           if (scores[i] > maxScore)
	              maxScore = scores[i];
	        return maxScore;
	   }
	   //****
	   public double computeMean()
	   {
	        double sum = 0;
	        for(int i = 0; i < scores.length; i ++)
	           sum += scores[i];
	        return sum / (double)scores.length;
	   }
	   //***
	   public double computeStandardDev(double mean)
	   {
	       float sumSquares = 0;
	       for(int i = 0; i < scores.length; i ++)
	           sumSquares += scores[i] * scores[i];
	       return Math.sqrt(sumSquares / (double)scores.length - mean*mean);
	   }

}
