import java.util.Random;
class PrintTask implements Runnable     //line 2
{
   private int sleepTime; // random sleep time //line 4
   private String threadName; // name of thread
   private static Random generator = new Random();
   // assign name to thread
   public PrintTask( String name )
   {
      threadName = name; // set name of thread  /line 10

      // pick random sleep time between 0 and 5 seconds
      sleepTime = generator.nextInt( 5000 );  //line 13
   } // end PrintTask constructor
   // method run is the code to be executed by new thread
   public void run()             //line 16                      
   {
    try // put thread to sleep for sleepTime amount of time
    {
      System.out.printf( "%s going to sleep for %d" +   //line 20
      		" milliseconds.\n", threadName, sleepTime );
      Thread.sleep( sleepTime ); // put thread to sleep
    } // end try
    // if thread interrupted while sleeping, print stack trace
    catch ( InterruptedException exception )  //line 25
    {
       exception.printStackTrace();
    } // end catch                            //line 28

    // print thread name
    System.out.printf( "%s done sleeping\n", threadName );
  } // end method run       //line 32
} // end class PrintTask


