import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Example15_7 
{
  public static void main( String[] args )
  {
    // create new thread pool with two threads
    ExecutorService app = Executors.newFixedThreadPool(2);

    // create UnsynchronizedBuffer to store ints       
    Buffer sharedLocation = new UnsynchronizedBuffer();
    System.out.println("Action\t\tValue\tProduced\tConsumed");
    System.out.println("------\t\t-----\t--------\t--------\n");

    // try to start producer and consumer giving each of 
    //them access to sharedLocation
    try
    {
     app.execute( new Producer( sharedLocation ) ); //line 20
     app.execute( new Consumer( sharedLocation ) ); //line 21
    } // end try
    catch ( Exception exception )
    {
      exception.printStackTrace();
    } // end catch

    app.shutdown(); // terminate application when threads end
  } // end main
} // end class SharedBufferTest




