// Consumer's run method loops ten times reading 
// a value from buffer.
import java.util.Random;
public class Consumer implements Runnable
{
  private static Random generator = new Random();
  //reference to shared object
  private Buffer sharedLocation; 
  // constructor
  public Consumer( Buffer shared )  //line 10
  {
    sharedLocation = shared;
  } // end Consumer constructor     //line 13
  // read sharedLocation's value four 
  //times and sum the values
  public void run()                 //line 16                                        
  {
    int sum = 0;

    for(int count = 1; count <= 10; count++)//line 20
    {
      // sleep 0 to 3 seconds, read value 
      // from buffer and add to sum
      try
      {
        Thread.sleep( generator.nextInt( 3000 ) );
        sum += sharedLocation.get();       //line 27
        System.out.printf( "\t\t\t%2d\n", sum );
      } // end try
      // if sleeping thread interrupted, print stack trace
      catch ( InterruptedException exception )
      {
        exception.printStackTrace();
      } // end catch
    } // end for                          //line 35

    System.out.printf( "\n%s %d.\n%s\n",
     "Consumer read values totaling", sum,
     "Terminating Consumer." );
  } // end method run               //line 40
} // end class Consumer



