import java.applet.*;
import java.awt.*;
import javax.swing.*;
public class TicTacToe extends JApplet
{
   //GUI objects
   private JButton[][] board = new JButton[3][3];
   private JPanel p;
   private JLabel l;
   //game pieces
   private Machine p1;
   private Human p2;
   //score-kepping devices
   //p1 will go first(see nextTurn below).
   private Player next = p2;     
   //gameOver stores winning player here.
   private Player winner = null; 
   //conts turns tacken. game ends when
   //all squares have taken
   private int turns = 0;        
                                 
   Font font = new Font("Helvetica", Font.BOLD, 18);
   public void init()
   {
      //create applet layout
      setLayout(new BorderLayout());
      //create panel of buttons
      p = new JPanel();
      p.setLayout(new GridLayout(3, 3));
      for(int r = 0; r < 3; r++)
         for(int c = 0; c < 3; c++)
         {
            board[r][c] = new JButton(" ");
            p.add(board[r][c]);
         }
      add(p, BorderLayout.CENTER);
      //create label at bottom
      l = new JLabel();
      add(l, BorderLayout.SOUTH);
      //create players; each player needs knowledge of THIS game
      p1 = new Machine("Machine", this);   //p1 will be X
      p2 = new Human("You", this);     //p2 will be 0
      //start play
      nextPlayer();
   }//end of init
   //check for winner FIRST! because the first
   //player could win on the last move.
   //Theoritically, turns should never exceed 9
   public boolean gameOver()
   {
      int r, c;
      return(findWinner(p1) || findWinner(p2) || turns >= 9);
   }
   //this is not necessary the best way to determine a winner.
   //it creates the side effect of registering the winner in th
   //data field winner. the method showWinner needs this.
   private boolean findWinner(Player p)
   {
     String name = p.getName();
     for(int r = 0; r < 3; r++)  //check rwos
         if ((board[r][0].getText() == name)
                && (board[r][1].getText() == name)
                 && (board[r][2].getText() == name))
          {
             winner = p;
             return true;
          }
     for(int c = 0; c < 3; c++)  //check columns
         if ((board[0][c].getText() == name)
                && (board[1][c].getText() == name)
                 && (board[2][c].getText() == name))
          {
             winner = p;
             return true;
          }

         //check diagonals
         if ((board[0][0].getText() == name)
                && (board[1][1].getText() == name)
                 && (board[2][2].getText() == name))
          {
             winner = p;
             return true;
          }

         if ((board[0][2].getText() == name)
                && (board[1][1].getText() == name)
                 && (board[2][0].getText() == name))
          {
             winner = p;
             return true;
          }

          return false; //no winner
   }
   //*************
   public void showWinner()
   {
      l.setFont(font);
      if(winner == p1)
          l.setText("Machine won");
      else if (winner == p2)
          l.setText("You won");
      else l.setText("It was a draw, no wone.");
    }
    //*******
    public void nextPlayer()
    {
       if(gameOver())
          showWinner();
       else
       {
           if(next == p1)  next = p2;
            else next = p1;
            //display current player
            l.setFont(font);
            l.setText("Player: " + next.getName());
            turns++;                 //count the number of turns
            next.takeTurn();
        }//end of else
    }//end of nextPlayer
    //*****************
    public void errorFound(String s)
    {
        l.setText("Fatal error, game terminated:" + s);
    }
    //*****************
    public JButton position(int r, int c)
    {
       return board[r][c];
    }
}



               




