import javax.swing.*;
import java.awt.*;
import java.applet.*;

public class ParameterApplet extends JApplet
{
  String fontName;
  int fontSize;
  float leading;
  boolean active;

  // Initialize the string to be displayed.
  public void start()
  {
    String param;
    fontName = getParameter("fontName");
    if(fontName == null)
      fontName = "Not Found";

    param = getParameter("fontSize");
    try {
      if(param != null) // if not found
        fontSize = Integer.parseInt(param);
      else
        fontSize = 0;
    } catch(NumberFormatException e) {
      fontSize = -1;
    }

    param = getParameter("leading");
    try
    {
      if(param != null) // if not found
        leading = Float.valueOf(param).floatValue();
      else
        leading = 0;
    }
    catch(NumberFormatException e)
    {
      leading = -1;
    }

    param = getParameter("accountEnabled");
    if(param != null)
      active = Boolean.valueOf(param).booleanValue();
  }

  // Display parameters.
  public void paint(Graphics g)
  {
    Font font = new Font(fontName, Font.BOLD, fontSize);
    g.setFont(font);
    g.drawString("Font name: " + fontName, 0, 20);
    g.drawString("Font size: " + fontSize, 0, 36);
    g.drawString("Leading: " + leading, 0, 52);
    g.drawString("Account Active: " + active, 0, 68);
  }
}

