// Using JSliders to size an oval.
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;   

public class SliderFrame extends JFrame
{
  private JSlider diameterJSlider; // slider to select diameter
  private OvalPanel myPanel; // panel to draw circle

   // no-argument constructor
  public SliderFrame()                                     //line 16
  {
     super ( "Slider Demo" );
     myPanel = new OvalPanel(); // create panel to draw circle //line 21
     myPanel.setBackground( Color.YELLOW ); // set background to yellow

     // set up JSlider to control diameter value                       
     diameterJSlider =                                                 //line 25
          new JSlider( SwingConstants.HORIZONTAL, 0, 200, 10 );        //line 26
     diameterJSlider.setMajorTickSpacing( 10 ); // create tick every 10//line 27
     diameterJSlider.setPaintTicks( true ); // paint ticks on slider   //line 28

     // register JSlider event listener                         
     diameterJSlider.addChangeListener(                                //line 31
     new ChangeListener() // anonymous inner class           
     {                                                       
        // handle change in slider value                     
        public void stateChanged( ChangeEvent e )                       //line 35        
        {                                                    
           myPanel.setDiameter( diameterJSlider.getValue() );           //line 37
        } // end method stateChanged                                    //line 38
     } // end anonymous inner class                          
    ); // end call to addChangeListener                                 //line 40

    add( diameterJSlider, BorderLayout.SOUTH ); // add slider to frame
    add( myPanel, BorderLayout.CENTER ); // add panel to frame
  } // end SliderFrame constructor                       //line 42
} // end class SliderFrame


