// A customized JPanel class.
import java.awt.Graphics;
import java.awt.Dimension;
import javax.swing.JPanel;
public class OvalPanel extends JPanel
{
   private int diameter = 10 ; // default diameter of 10

   // draw an oval of the specified diameter
   public void paintComponent( Graphics g )   //line 10
   {
      super.paintComponent( g );

      g.fillOval( 10, 10, diameter, diameter ); // draw circle
   } // end method paintComponent             //line 15

   // validate and set diameter, then repaint
   public void setDiameter( int newDiameter )   //line 18
   {
      // if diameter invalid, default to 10
      diameter = ( newDiameter >= 0 ? newDiameter : 10 );
      repaint(); // repaint panel
   } // end method setDiameter                  //line 23

   // used by layout manager to determine preferred size
   public Dimension getPreferredSize()           //line 26
   {
      return new Dimension( 200, 200 );
   } // end method getPreferredSize              //line 30

   // used by layout manager to determine minimum size
   public Dimension getMinimumSize()             //line 33
   {                                                  
      return getPreferredSize();                      
   } // end method getMinimumSize                //line 36      
} // end class OvalPanel


