import java.awt.Color;
import java.awt.Graphics;
import java.awt.BasicStroke;  
import java.awt.GradientPaint;
import java.awt.TexturePaint; 
import java.awt.Rectangle;
import java.awt.Graphics2D;           
import java.awt.geom.Ellipse2D;       
import java.awt.geom.Rectangle2D;     
import java.awt.geom.RoundRectangle2D;
import java.awt.geom.Arc2D;           
import java.awt.geom.Line2D;          
import java.awt.image.BufferedImage;  
import javax.swing.JPanel;

public class ShapesDraw extends JPanel
{
    public void paintComponent( Graphics g )                        //line 18                   
    {
      super.paintComponent( g ); // call superclass's paintComponent //line 20
      Graphics2D g2d = ( Graphics2D ) g; // cast g to Graphics2D     //line 21

      // draw 2D ellipse filled with a blue-yellow gradient          //line 23
      g2d.setPaint( new GradientPaint( 5, 30, Color.BLUE, 35, 100,   //line 24
          Color.YELLOW, true ) );                                    
      g2d.fill( new Ellipse2D.Double( 5, 30, 65, 100 ) );            //line 25

      // draw 2D rectangle in red                           
      g2d.setPaint( Color.RED );                                     //line 28
      g2d.setStroke( new BasicStroke( 10.0f ) );                     //line 29
      g2d.draw( new Rectangle2D.Double( 80, 30, 65, 100 ) );         //line 30

      // draw 2D rounded rectangle with a buffered background
      BufferedImage buffImage = new BufferedImage( 10, 10,   
        BufferedImage.TYPE_INT_RGB );                                //line 33

     // obtain Graphics2D from bufferImage and draw on it
     Graphics2D gg = buffImage.createGraphics();                     //line 36
     gg.setColor( Color.YELLOW ); // draw in yellow                  //line 37
     gg.fillRect( 0, 0, 10, 10 ); // draw a filled rectangle         //line 38
     gg.setColor( Color.BLACK ); // draw in black                    //line 39
     gg.drawRect( 1, 1, 6, 6 ); // draw a rectangle                  //line 40
     gg.setColor( Color.BLUE ); // draw in blue                      //line 41
     gg.fillRect( 1, 1, 3, 3 ); // draw a filled rectangle           //line 42
     gg.setColor( Color.RED ); // draw in red                        //line 43
     gg.fillRect( 4, 4, 3, 3 ); // draw a filled rectangle           //line 44

    // paint buffImage onto the JFrame                           
    g2d.setPaint( new TexturePaint( buffImage,                       
        new Rectangle( 10, 10 ) ) );                                 //line 47
    g2d.fill(                                      
        new RoundRectangle2D.Double( 155, 30, 75, 100, 50, 50 ) );   //line 48

    // draw 2D pie-shaped arc in white                               //line 50
    g2d.setPaint( Color.WHITE );                                     //line 51
    g2d.setStroke( new BasicStroke( 6.0f ) );                        //line 52
    g2d.draw(                                                    
         new Arc2D.Double( 240, 30, 75, 100, 0, 270, Arc2D.PIE ) );  //line 53
    // draw 2D lines in green and yellow               
    g2d.setPaint( Color.GREEN );                                     //line 55
    g2d.draw( new Line2D.Double( 395, 30, 320, 150 ) );              //line 56

    // draw 2D line using stroke                             
    float dashes[] = { 10 }; // specify dash pattern                 //line 59
    g2d.setPaint( Color.YELLOW );                                    //line 60
    g2d.setStroke( new BasicStroke( 4, BasicStroke.CAP_ROUND,
    BasicStroke.JOIN_ROUND, 10, dashes, 0 ) );                       //line 61
    g2d.draw( new Line2D.Double( 320, 30, 395, 150 ) );              //line 62
  } // end method paintComponent                                     //line 63
}                                                                    //line 64




