import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
public class LabelsColorsFonts extends JFrame
{
    private JLabel javaL, programmingL;             //line 6
                                                    //line 7
    private JButton colorB, fontB;                  //line 8

    private ColorButtonHandler cHandler;            //line 10
    private FontButtonHandler fHandler;             //line 11
    private Container pane;                         //line 12

    public LabelsColorsFonts()                      //line 14
    {
             //Create two labels
        javaL = new JLabel("Java", SwingConstants.CENTER);  //line 17
        programmingL = new JLabel("Programming",
                                  SwingConstants.CENTER);   //line 19

             //Create color button
        colorB = new JButton("Color");                      //line 22
        cHandler = new ColorButtonHandler();                //line 23
        colorB.addActionListener(cHandler);                 //line 24

             //Create font button
        fontB = new JButton("Font");                        //line 27
        fHandler = new FontButtonHandler();                 //line 28
        fontB.addActionListener(fHandler);                  //line 29

             //Set the title of the window
        setTitle("Labels, fonts, and colors demonstration");//line 32

             //Get the container
        pane = getContentPane();                            //line 35

             //Set the layout
        pane.setLayout(new GridLayout(2, 2));               //line 38

             //Place the components in the pane
        pane.add(javaL);                                    //line 41
        pane.add(programmingL);                             //line 42
        pane.add(colorB);                                   //line 43
        pane.add(fontB);                                    //line 44
    }                                                       //line 45
    //*********************************
    private class ColorButtonHandler implements ActionListener //line 47
    {
        public void actionPerformed(ActionEvent e)
        {
            javaL.setForeground(Color.red);
            programmingL.setForeground(Color.blue);

            pane.setBackground(Color.cyan);

            colorB.setBackground(Color.orange);
            fontB.setBackground(Color.orange);
        }
    }//end of class ColorButtonHandler                        //line 59
    //***********************************
    private class FontButtonHandler implements ActionListener //line 61
    {
        public void actionPerformed(ActionEvent e)            //line 63
        {
            javaL.setFont(new Font("Arial", Font.BOLD, 24));
            programmingL.setFont(new Font("Arial", Font.BOLD, 24));
        }
    }//end of classFontHandler class                        //line 68
}//end of class LabelsColorsFonts                           //line 69
