import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
public class CircleProgram extends JFrame 
{
	   private JLabel radiusL, areaL, circumferenceL;    //line 6

	   private JTextField radiusTF, areaTF, circumferenceTF;//line 8

	   private JButton calculateB, exitB;                 //line 10

 	   private CalculateButtonHandler cbHandler;          //line 12
	   private ExitButtonHandler ebHandler;               //line 13

	   public CircleProgram()                             //line 15
	   {
	             //Create the three labels
	      radiusL = new JLabel("Enter the radius: ",
	                                  SwingConstants.RIGHT);//line 18
	      areaL = new JLabel("Area: ", SwingConstants.RIGHT);
	      circumferenceL = new JLabel("Circumference: ",    
	                                  SwingConstants.RIGHT);//line 19

	             //Create the three text fields
	      radiusTF = new JTextField(10);                    //line 22
	      areaTF = new JTextField(10);                      //line 23
	      circumferenceTF = new JTextField(10);             //line 24

	             //Create Calculate Button
	      calculateB = new JButton("Calculate");            //line 27
	      cbHandler = new CalculateButtonHandler();         //line 28
	      calculateB.addActionListener(cbHandler);          //line 29

	             //Create Exit Button
	      exitB = new JButton("Exit");                      //line 32
	      ebHandler = new ExitButtonHandler();              //line 33
	      exitB.addActionListener(ebHandler);               //line 34

	             //Set the title of the window
	      setTitle("Area and Circumference of a Circle");   //line 37

	             //Get the container
	      Container pane = getContentPane();                //line 40

	             //Set the layout
	      pane.setLayout(new GridLayout(4, 2));             //line 43

	             //Place the components in the pane
	      pane.add(radiusL);                                //line 46
	      pane.add(radiusTF);
	      pane.add(areaL);
	      pane.add(areaTF);
	      pane.add(circumferenceL);
	      pane.add(circumferenceTF);
	      pane.add(calculateB);
	      pane.add(exitB);                                 //line 54
	   }   //end of constructor                            //line 55
       //*****************                                 //line 56
	   private class CalculateButtonHandler implements ActionListener
	   {
	      public void actionPerformed(ActionEvent e)
	      {
	         double radius, area, circumference;

	         radius = Double.parseDouble(radiusTF.getText());
	         area = Math.PI * radius * radius;
	         circumference = 2 * Math.PI * radius;

	         areaTF.setText("" + String.format("%.2f%n", area));
	          circumferenceTF.setText("" +
	                        String.format("%.2f%n", circumference));
	      }
	   }                                                   //line 71 
       //*****************                                 //line 72
	   private class ExitButtonHandler implements ActionListener
	   {
	       public void actionPerformed(ActionEvent e)
	       {
	           System.exit(0);
	       }
	   }                                                   //line 79 
}                                                         //line 80
