  import java.awt.BorderLayout;
  import java.awt.event.ActionListener;
  import java.awt.event.ActionEvent;
  import javax.swing.JFrame;
  import javax.swing.JButton;

  public class BorderLayoutFrame extends JFrame implements ActionListener
  {
	 // array of buttons to hide portions
	 private JButton buttons[];                                   //line 10 
     private final String names[] = { "Hide North", "Hide South",
        "Hide East", "Hide West", "Hide Center" };                //line 11
     private BorderLayout layout; // borderlayout object          //line 12

     // set up GUI and event handling
     public BorderLayoutFrame()                                   //line 15
     {
        super( "BorderLayout Demo" );                             //line 17

        layout = new BorderLayout( 5, 5 ); // 5 pixel gaps        //line 19
        setLayout( layout ); // set frame layout          
        // set size of array
        buttons = new JButton[ names.length ];                    //line 22

        // create JButtons and register listeners for them
        for ( int count = 0 ; count < names.length; count++ )     //line 25
        {
           buttons[ count ] = new JButton( names[ count ] );      //line 28
           buttons[ count ].addActionListener( this );            //line 29
        } // end for                                              //line 30
        // add button to north
        add( buttons[ 0 ], BorderLayout.NORTH );                  //line 31 
        // add button to south
        add( buttons[ 1 ], BorderLayout.SOUTH );
        // add button to east
        add( buttons[ 2 ], BorderLayout.EAST ); 
        // add button to west
        add( buttons[ 3 ], BorderLayout.WEST );   
        // add button to center
        add( buttons[ 4 ], BorderLayout.CENTER );                  //line 39
     } // end BorderLayoutFrame constructor                        //line 40

     // handle button events
     public void actionPerformed( ActionEvent event )              //line 43
     {
        // check event source and layout content pane correspondingly
        for ( JButton button : buttons )
        {
           if ( event.getSource() == button )
              button.setVisible( false ); // hide button clicked
           else
              button.setVisible( true ); // show other buttons
        } // end for

        layout.layoutContainer( getContentPane() ); // layout content pane
     } // end method actionPerformed                                //line 55
  } // end class BorderLayoutFrame                                  //line 56
