import java.io.*;
public class Example10_13
{
    /* Illustrate the InputStreamReader and OutputStreamWriter classes
     * by making a copy of the command line argument in the
     * file output.txt. The input file will be assumed to be stored
     * in the system-default character encoding. The output file
     * will be written using an arbitrary Japanese encoding, simply for
     * illustrative purposes.
     */
    // Any Exceptions caused program termination.
    public static void main(String[] args)
                        throws FileNotFoundException, IOException 
        {
            // Which output encoding to use - arbitrary in this example.
            final String outputEncoding = "JIS";
            // Get the system default encoding for the input file.
            String inputEncoding = System.getProperty("file.encoding");
            if(inputEncoding == null)
            {
                // Use the output encoding for lack of anything else.
                inputEncoding = outputEncoding;
            }
            // Set up the file names.
            final String inputFile = "test.txt", outputFile = "output.txt";
            InputStreamReader inFile = new InputStreamReader(
                            new FileInputStream(inputFile), inputEncoding);
            OutputStreamWriter outFile = new OutputStreamWriter(
                            new FileOutputStream(outputFile), outputEncoding);
            System.out.println("Reading " + inputFile+
                               " in encoding " + inFile.getEncoding()+
                               " and writing to " + outputFile+
                               " in " + outFile.getEncoding());
            // Provide space for a small number of characters to be read.
            final int bufferSize = 1024;
            char[] buffer = new char[bufferSize];
            int numberRead = inFile.read(buffer);
            while(numberRead > 0)
            {
                outFile.write(buffer,0,numberRead);
                numberRead = inFile.read(buffer);
            }
            inFile.close();
            outFile.close();
    }
}
