public class SynchronizedBuffer implements Buffer
{
  // shared by producer and consumer threads
  private int buffer = -1;           //line 4
  //count of occupied buffers
  private boolean occupied = false; //line 6
  // place value into buffer
  public synchronized void set(int value) //line 8
  {
    // while there are no empty locations,
    //place thread in waiting state
    while ( occupied )
    {
     // output thread information and buffer 
     //	information, then wait
     try
     {
       System.out.println("Producer tries to write.");
       displayState("Buffer full. Producer waits.");
       wait();
     } // end try
     catch ( InterruptedException exception )
     {
       exception.printStackTrace();
     } // end catch
    } // end while
    buffer = value; // set new buffer value
    // indicate producer cannot store another value 
    // until consumer retrieves current buffer value
    occupied = true;                                

    displayState( "Producer writes " + buffer );
    //tell waiting thread to enter runnable state
    notify();
   } // end method set               //line 35

   // return value from buffer
   public synchronized int get()     //line 38 
   {
     // while no data to read, place
	 // thread in waiting state
     while ( !occupied )
     {
       // output thread information and buffer
       // information, then wait
       try
       {
         System.out.println("Consumer tries to read.");
         displayState("Buffer empty. Consumer waits.");
         wait();
       } // end try
       catch ( InterruptedException exception )
       {
          exception.printStackTrace();
       } // end catch
     } // end while
     //indicate that producer can store another value
     //because consumer just retrieved buffer value  
     occupied = false;                                
     int readValue = buffer; // store value in buffer
     displayState( "Consumer reads " + readValue );
     // tell waiting thread to enter runnable state
     notify(); 
     return readValue;
   } // end method get                 //line 65
   // display current operation and buffer state
   public void displayState( String operation )
   {
      System.out.printf( "%-40s%d\t\t%b\n\n",
    	  operation, buffer, occupied );
   } // end method displayState
} // end class SynchronizedBuffer


