import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class RandomCharacters extends JFrame 
                implements ActionListener
{
   // number of threads
   private final static int SIZE = 3;
   // array of JCheckBoxes
   private JCheckBox checkboxes[];
   // single lock
   private Lock lockObject = new ReentrantLock(true);
   // array of RunnableObjects to display 
   //random characters
   private RunnableObject[] randomCharacters =
   new RunnableObject[ SIZE ];
   // set up GUI and arrays
   public RandomCharacters()
   {
     // allocate space for array
     checkboxes = new JCheckBox[ SIZE ]; 
     // set layout
     setLayout( new GridLayout( SIZE, 2, 5, 5 ) ); 

     // create new thread pool with SIZE threads                   
     ExecutorService runner = 
    	         Executors.newFixedThreadPool(SIZE);
     // loop SIZE times
     for ( int count = 0; count < SIZE; count++ )
     {
    	// create JLabel
        JLabel outputJLabel = new JLabel(); 
        outputJLabel.setBackground( Color.GREEN ); 
        // create JLabel
        outputJLabel.setOpaque( true ); 
        add( outputJLabel ); // add JLabel to JFrame
        // create JCheckBox to control 
        //suspend/resume state
        checkboxes[count] = new JCheckBox("Suspended");
        // add listener which executes when 
        //JCheckBox is clicked
        checkboxes[count].addActionListener( this );
        // add JCheckBox to JFrame
        add( checkboxes[ count ] ); 
        // create a new RunnableObject
        randomCharacters[ count ] =
        new RunnableObject( lockObject, outputJLabel );
        // execute RunnableObject                   
        runner.execute( randomCharacters[ count ] );
      } // end for
      setSize( 275, 90 ); // set size of window
      setVisible( true ); // show window
      //shutdown runner when threads finish
      runner.shutdown(); 
    } // end RandomCharacters constructor
    // handle JCheckBox events
    public void actionPerformed( ActionEvent event )
    {
      // loop over all JCheckBoxes in array
      for(int count = 0; count < checkboxes.length; count++)
      {
       // check if this JCheckBox was source of event
       if ( event.getSource() == checkboxes[ count ] )
           // toggle state
           randomCharacters[ count ].toggle(); 
      } // end for
    } // end method actionPerformed
} // end class RandomCharacters




