import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.JFileChooser;
import java.io.*;
import java.util.*;

public class TextEditor2 extends JFrame implements ActionListener
{
   private JMenuBar menuBar =  new JMenuBar(); //create the menu bar
   private JMenu fileMenu, editMenu;
   private JMenuItem exitItem;
   private JMenuItem saveItem;
   private JMenuItem openItem;
   private JMenuItem cutItem, copyItem, pasteItem, selectItem;
   private JTextArea pageText = new JTextArea();
   private String scratchpad = "";
   private JFileChooser fc = new JFileChooser();
   //Constructor
   public TextEditor2()
   {
      setTitle("Simple Text Editor");
      Container pane = getContentPane();

      pane.setLayout(new BorderLayout());
      pane.add(pageText, BorderLayout.CENTER);
      pane.add(new JScrollPane(pageText));
      pageText.setLineWrap(true);

      setJMenuBar(menuBar);
      setFileMenu();
      setEditMenu();
   }//end of constructor
   //*******************
   private void setFileMenu()
   {
      fileMenu = new JMenu("File");
      menuBar.add(fileMenu);
      exitItem = new JMenuItem("Exit");
      fileMenu.add(exitItem);
      exitItem.addActionListener(this);
      
      saveItem = new JMenuItem("Save");
      fileMenu.add(saveItem);
      saveItem.addActionListener(this);

      openItem = new JMenuItem("Open");
      fileMenu.add(openItem);
      openItem.addActionListener(this);
   }
   //*******************
   private void setEditMenu()
   {
      editMenu = new JMenu("Edit");
      menuBar.add(editMenu);
      cutItem = new JMenuItem("Cut");
      editMenu.add(cutItem);
      cutItem.addActionListener(this);
      
      copyItem = new JMenuItem("Copy");
      editMenu.add(copyItem);
      copyItem.addActionListener(this);
      
      pasteItem = new JMenuItem("Paste");
      editMenu.add(pasteItem);
      pasteItem.addActionListener(this);
      
      selectItem = new JMenuItem("Select All");
      editMenu.add(selectItem);
      selectItem.addActionListener(this);
   }
   //*******************
   public void actionPerformed(ActionEvent e) 
   {
     JMenuItem mItem = (JMenuItem) e.getSource();

     if (mItem == exitItem)
     {
         System.exit(0);
     }
     else if(mItem == saveItem)
     {
	    fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
	    int result = fc.showSaveDialog(this);
	    if(result == JFileChooser.CANCEL_OPTION)
		      System.exit(1);
	    if(result == JFileChooser.APPROVE_OPTION)
	    {
	     	try
		    {
    	        File f = fc.getSelectedFile();
                PrintWriter out = new  PrintWriter(f); //Step 3
            	pageText.selectAll();
        		String s = pageText.getSelectedText();
                out.print(s);		
		        out.close();
		     }
		     catch(Exception e1)
		     {
			
		     }
	    }
     }//end of else if
     
     else if(mItem == openItem)
     {
 	    fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
	    int result = fc.showOpenDialog(this);
	    if(result == JFileChooser.CANCEL_OPTION)
		      System.exit(1);
	    if(result == JFileChooser.APPROVE_OPTION)
	    {
	     	try
		    {
    	       File f = fc.getSelectedFile();
    	       if(!f.isFile())
    	       {
    	    	   JOptionPane.showMessageDialog(this, "Invalid File Name");
    	    	   System.exit(1);
    	       }
    	       Scanner inFile =  new Scanner(new FileReader(f));    
               String s, text = "";
               while(inFile.hasNext())
               {
                   s = inFile.nextLine();
                   text = text + "\n" + s;    
            	   
               }
               pageText.setText(text);
               inFile.close();
		     }
		     catch(Exception e1)
		     {
			
		     }
	    }
 
     } //end of else if

     else if (mItem == cutItem)
     {
       scratchpad = pageText.getSelectedText();
       pageText.replaceRange("",
       pageText.getSelectionStart(),
       pageText.getSelectionEnd());
     }
     else if (mItem == copyItem)
         scratchpad = pageText.getSelectedText();
     else if (mItem == pasteItem)
         pageText.insert(scratchpad, pageText.getCaretPosition());
     else if (mItem == selectItem)
         pageText.selectAll();
  }//end of actionPerformed
}
