import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class MouseDetails extends JFrame
{
   
   private String details; 
// JLabel that appears at bottom of window
   private JLabel statusBar; 

   // constructor sets title bar String and 
   //register mouse listener
   public MouseDetails()
   {
      super( "Mouse clicks and buttons" );
      statusBar = new JLabel( "Click the mouse" );
      add( statusBar, BorderLayout.SOUTH );
      // add handler
      addMouseListener( new MouseClickHandler() ); //line 22
   } // end MouseDetailsFrame constructor

   // inner class to handle mouse events
   private class MouseClickHandler extends MouseAdapter //line 26
   {
      // handle mouse click event and determine 
	  //which button was pressed
      public void mouseClicked( MouseEvent event ) //line 30
      {
         details = String.format( "Clicked %d time(s)",
               event.getClickCount() );
         // right mouse button  
         if ( event.isMetaDown() )                 //line 35
             details += " with right mouse button";
         // middle mouse button 
         else if ( event.isAltDown() )              //line 38
              details += " with center mouse button";
         else // left mouse button
             details += " with left mouse button";
      // display message in statusBar

           statusBar.setText( details ); 
      } // end method mouseClicked                  //line 45
   } // end private inner class MouseClickHandler
} // end class MouseDetails






