	public class ArrayListClass
	{
	    int[] list;
	    int numOfElements;

	      //Default constructor.
	      //Instantiates an array of size 5.
	      //Postcondition: list points to an array of size 5.
	      //               numOfElements = 0;
	    public ArrayListClass()
	    {
	        list = new int[5];
	        numOfElements = 0;
	    }

	      //Constructor.
	      //Instantiates an array of the size specified by the user.
	      //Postcondition: list points to an array of size
	      //               arraySize.
	      //               numOfElements = 0;
	    public ArrayListClass(int arraySize)
	    {
	        list = new int[arraySize];
	        numOfElements = 0;
	    }

	      //Method to return the length of the array.
	      //Postcondition: The value of list.length is
	      //               returned.
	    public int listSize()
	    {
	        return list.length;
	    }

	      //Method to insert an element at the end of the list.
	      //Postcondition: If numOfElements < list.length - 1
	      //                  list[numOfElements++] = elem;
	      //               otherwise output an appropriate error
	      //               message.
	    public void insertEnd(int elem)
	    {
	        if (numOfElements < list.length)
	            list[numOfElements++] = elem;
	        else
	            System.out.println("Cannot insert because the "
	                             + "list is full.");
	    }

	      //Method to return the element at the position specified
	      //by index.
	      //This method does not determine if index is out-of-bound
	      //Postcondition: retrun list[index];
	    public int elementAt(int index)
	    {
	        return list[index];
	    }

	       //Method to return the elements of list as a string.
	       //Elements are separated by commas and spaces.
	       //Postcondition: Elements of list are returned as a
	       //               string.
	    public String toString()
	    {
	        String str = "[";

	        for (int index = 0; index < numOfElements - 1; index++)
	            str = str + list[index] + ", ";

	        if (numOfElements > 0)
	            str = str + list[numOfElements - 1] + "]";
	        else
	            str = str + "]";

	        return str;
	    }

	       //Method to return the sum of the elements of list
	       //Postcondition: Sum of the elements of list is returned.
	    public int sumArray()
	    {
	        int sum = 0;

	        for (int index = 0; index < numOfElements; index++)
	             sum = sum + list[index];

	        return sum;
	    }
	       //Method to find and return the index of the first
	       //occurrence of the largest element, if it repeats,
	       //in an int array.
	       //This method does not check if list is empty.
	       //Postcondition: The index of the first occurence of the
	       //               largest element is returned.
	    public int indexLargestElement()
	    {
	        int maxIndex = 0; //Assume first element is the largest

	        for (int index = 1; index < numOfElements; index++)
	             if (list[maxIndex] < list[index])
	                 maxIndex = index;

	        return maxIndex;
	    }

	       //Method to copy one array into another array. The
	       //elements of otherList are copied into list. The
	       //array list must be at least as large as the number
	       //of elements to be copied.
	       //Postcondition: The parameter numOfElements specifies
	       //               the number of elements of list1 to be
	       //               copied into list2.
	    public void makeCopy(ArrayListClass otherList)
	    {
	        numOfElements = otherList.numOfElements;

	        for (int index = 0; index < otherList.numOfElements;
	                            index++)
	             list[index] = otherList.list[index];
	    }

	       //Method to sort list using selection sort algorithm.
	       //Postcondition: The array list is sorted
	    public void selectionSort()
	    {
	        int smallestIndex;
	        int minIndex;
	        int temp;

	        for (int index = 0; index < numOfElements - 1; index++)
	        {
	                //Step a
	            smallestIndex = index;

	            for (minIndex = index + 1; minIndex < numOfElements;
	                                       minIndex++)
	                if (list[minIndex] < list[smallestIndex])
	                    smallestIndex = minIndex;

	                //Step b
	            temp = list[smallestIndex];
	            list[smallestIndex] = list[index];
	            list[index] = temp;
	        }
	    } //end selectionSort



}
