// Producer's run method stores the values 
// 1 to 10 in buffer.
import java.util.Random;

public class Producer implements Runnable
{
   private static Random generator = new Random();
   // reference to shared object
   private Buffer sharedLocation; 
  // constructor
  public Producer( Buffer shared ) //line 11
  {
      sharedLocation = shared;
  } // end Producer constructor    //line 14
  // store values from 1 to 10 in sharedLocation
  public void run()          //line 16                         
  {
    int sum = 0;
    for ( int count = 1; count <= 10; count++ ) //line 19 
    {
      try // sleep 0 to 3 seconds, then place value in Buffer
      {
        // sleep thread
        Thread.sleep( generator.nextInt( 3000 ) ); //line 24
        sharedLocation.set( count ); // set value in buffer
        sum += count; // increment sum of values   //line 26
        System.out.printf( "\t%2d\n", sum );
      } // end try
      // if sleeping thread interrupted, print stack trace
      catch ( InterruptedException exception )
      {
        exception.printStackTrace();
      } // end catch
    } // end for                                //line 34
    System.out.printf( "\n%s\n%s\n", "Producer done " +
    		"producing.", "Terminating Producer." );
  } // end method run                   //line  37
} // end class Producer



