import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class TextEditor extends JFrame implements
                         ActionListener
{
   //create the menu bar
   private JMenuBar menuBar = new JMenuBar();     //line 9
   private JMenu fileMenu, editMenu;              //line 10
   private JMenuItem exitItem;                    //line 11
   private JMenuItem saveItem;                    //line 12
  
   private JMenuItem cutIitem, copyIitem,         //line 14
               pasteI, selectIitem;               
   private JTextArea pageTA = new JTextArea();    //line 16
   private String scratchpad = "";                //line 17
   public TextEditor()                            //line 18
   {
      setTitle("Simple Text Editor");              //line 20

      Container pane = getContentPane();           //line 22

      pane.setLayout(new BorderLayout());          //line 24
      pane.add(pageTA, BorderLayout.CENTER);       //line 25
      pane.add(new JScrollPane(pageTA));           //line 26
      pageTA.setLineWrap(true);                    //line 27
      setJMenuBar(menuBar);                        //line 28
      setFileMenu();                               //line 29
      setEditMenu();                               //line 30
   }                                               //line 31
   //***********************
   private void setFileMenu()                      //line 33
   {
      fileMenu = new JMenu("File");                //line 35
      menuBar.add(fileMenu);                       //line 36
      exitItem = new JMenuItem("Exit");            //line 37
      fileMenu.add(exitItem);                      //line 38
      exitItem.addActionListener(this);            //line 39
      saveItem = new JMenuItem("Save As");         //line 40
      fileMenu.add(saveItem);                      //line 41
      saveItem.setEnabled(true);                   //line 42
      saveItem.addActionListener(this);            //line 43
   }                                               //line 44
   //***********************
   private void setEditMenu()                      //line 46
   {
      editMenu = new JMenu("Edit");                //line 48
      menuBar.add(editMenu);                       //line 49
      cutIitem = new JMenuItem("Cut");             //line 50
      editMenu.add(cutIitem);                      //line 51
      cutIitem.addActionListener(this);            //line 52
      copyIitem = new JMenuItem("Copy");           //line 53
      editMenu.add(copyIitem);                     //line 54
      copyIitem.addActionListener(this);           //line 55
      pasteI = new JMenuItem("Paste");             //line 56
      editMenu.add(pasteI);                        //line 57
      pasteI.addActionListener(this);              //line 58
      selectIitem = new JMenuItem("Select All");   //line 59
      editMenu.add(selectIitem);                   //line 60
      selectIitem.addActionListener(this);         //line 61
   }                                               //line 62
   //***********************
   public void actionPerformed(ActionEvent e)      //line 64
   {
      JMenuItem mItem = (JMenuItem) e.getSource(); //line 66
      if (mItem == exitItem)                       //line 67
      {
         System.exit(0);
      }                                            //line 70
      else if(mItem == saveItem)                   //line 71
      {
    	  boolean saveOk = !saveItem.isEnabled();
    	  saveItem.setEnabled(saveOk);
      }                                            //line 75
      else if (mItem == cutIitem)                  //line 76
      {
         scratchpad = pageTA.getSelectedText();
         pageTA.replaceRange("",                   //line 79
                     pageTA.getSelectionStart(),
                     pageTA.getSelectionEnd());
      }                                            //line 82
      else if (mItem == copyIitem)                 //line 83
          scratchpad = pageTA.getSelectedText();
      else if (mItem == pasteI)                    //line 85
           pageTA.insert(scratchpad,
        		      pageTA.getCaretPosition());
      else if (mItem == selectIitem)               //line 88
           pageTA.selectAll();
   }                                               //line 89
}