import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;

public class SimpleTree extends JFrame
{
  public SimpleTree()                             //line 7 
  {
    super("Creating a Simple JTree");
    Container content = getContentPane();         //line 10
    Object[] hierarchy =                          //line 11
      { "javax.swing",
        "javax.swing.border",
        "javax.swing.colorchooser",
        "javax.swing.event",
        "javax.swing.filechooser",
        new Object[] { "javax.swing.plaf",        //line 17
                       "javax.swing.plaf.basic",
                       "javax.swing.plaf.metal",
                       "javax.swing.plaf.multi" },
        "javax.swing.table",
        new Object[] { "javax.swing.text",         //line 22
                  new Object[] { "javax.swing.text.html",
                       "javax.swing.text.html.parser" },
                       "javax.swing.text.rtf" },
        "javax.swing.tree",
        "javax.swing.undo" };                       //line 27
    DefaultMutableTreeNode root = processHierarchy(hierarchy);
    JTree tree = new JTree(root);                   //line 29
    content.add(new JScrollPane(tree), BorderLayout.CENTER);
  }                                                      //line 31
  /** Small routine that will make node out of the first entry
   *  in the array, then make nodes out of subsequent entries
   *  and make them child nodes of the first one. The process is
   *  repeated recursively for entries that are arrays.
   */                                                     //line 36
  private DefaultMutableTreeNode processHierarchy(Object[] hierarchy)
  {
    DefaultMutableTreeNode node =
      new DefaultMutableTreeNode(hierarchy[0]);
    DefaultMutableTreeNode child;
    for(int i=1; i < hierarchy.length; i++)       //line 42
    {
      Object nodeSpecifier = hierarchy[i];
      if (nodeSpecifier instanceof Object[]) // node with children
        child = processHierarchy((Object[])nodeSpecifier);
      else
        child = new DefaultMutableTreeNode(nodeSpecifier); // Leaf
      node.add(child);
    }                                                //line 50
    return(node);
  }  //end of processHierarchy                       //line 52
}

