import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import javax.swing.*;
  /*  This desktop frame contains 
   * editor panes that show HTML documents.
 */
class DesktopFrame extends JFrame
{
  private JDesktopPane desktop;
  private int nextFrameX;
  private int nextFrameY;
  private int frameDistance;
  private int counter;
  private static final String[] books =
  {
    "Java",
    "C++",
    "C#.NET",
    "Network",
    "Delphi",
    "SQLserver",
    "PHP",
    "Pascal",
    "Algorithms",
  };

  private static final int DEFAULT_WIDTH = 600;
  private static final int DEFAULT_HEIGHT = 400;

  public DesktopFrame()                        //line 31
  {
   setTitle("InternalFrameTest");               //line 33
   setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
   desktop = new JDesktopPane();
   add(desktop, BorderLayout.CENTER);

   // set up menus
   JMenuBar menuBar = new JMenuBar();           //line 39
   setJMenuBar(menuBar);
   JMenu fileMenu = new JMenu("File");
   menuBar.add(fileMenu);
   JMenuItem openItem = new JMenuItem("New");   //line 43
   fileMenu.add(openItem);                        //line 44
   openItem.addActionListener(new ActionListener() //line 45
   {
     public void actionPerformed(ActionEvent event)
     {
       createInternalFrame(
       new JLabel(new ImageIcon(books[counter] + ".gif")),
            books[counter]);
       counter = (counter + 1) % books.length;
     }
   });                                            //line 54
   JMenuItem exitItem = new JMenuItem("Exit");    //line 55
   exitItem.addActionListener(new                 //line 56
   ActionListener()                               //line 57
   {
     public void actionPerformed(ActionEvent event)
     {
       System.exit(0);
     }
   });                                           //line 63
   fileMenu.add(exitItem);                       //line 64
   JMenu windowMenu = new JMenu("Window");       //line 65
   menuBar.add(windowMenu);
   JMenuItem nextItem = new JMenuItem("Next");   //line 68
   windowMenu.add(nextItem);                      //line 69
   nextItem.addActionListener(new                //line 70
   ActionListener()                              
   {
     public void actionPerformed(ActionEvent event)
     {
       selectNextWindow();
     }
   });                                            //line 75
   JMenuItem cascadeItem = new JMenuItem("Cascade");//line 76
   windowMenu.add(cascadeItem);                     //line 77
   cascadeItem.addActionListener(new              //line 78
   ActionListener()                             
   {
     public void actionPerformed(ActionEvent event)
     {
       cascadeWindows();
     }
   });                                            //line 85
   JMenuItem tileItem = new JMenuItem("Tile");    //line 86
   windowMenu.add(tileItem);                      //line 87
   tileItem.addActionListener(new                 //line 88
   ActionListener()                               //line 90
   {
     public void actionPerformed(ActionEvent event)
     {
       tileWindows();
     }
   });                                            //line 96
   final JCheckBoxMenuItem dragOutlineItem =      //line 97
	       new JCheckBoxMenuItem("Drag Outline");
   windowMenu.add(dragOutlineItem);               //line 98
   dragOutlineItem.addActionListener(new          //line 99
   ActionListener()
   {
     public void actionPerformed(ActionEvent event)
     {
       desktop.setDragMode(dragOutlineItem.isSelected()
       ? JDesktopPane.OUTLINE_DRAG_MODE
       : JDesktopPane.LIVE_DRAG_MODE);
     }
   });                                            //line 108
  }//end of desktop constructor                   //line 109
  /**
   Creates an internal frame on the desktop.
   @param c the component to display in the internal frame
   @param t the title of the internal frame.
  */
  public void createInternalFrame(Component c, String t)//line 115 
  {
    final JInternalFrame iframe = new JInternalFrame(t,
    true, // resizable
    true, // closable
    true, // maximizable
    true); // iconifiable

    iframe.add(c, BorderLayout.CENTER);
    desktop.add(iframe);

    iframe.setFrameIcon(new ImageIcon("document.gif"));

    // add listener to confirm frame closing
    iframe.addVetoableChangeListener(new
    VetoableChangeListener()
    {
      public void vetoableChange(PropertyChangeEvent event)
        throws PropertyVetoException
      {
        String name = event.getPropertyName();
        Object value = event.getNewValue();

        // we only want to check attempts to close a frame
        if (name.equals("closed") && value.equals(true))
        {
           // ask user if it is ok to close
           int result = JOptionPane.showInternalConfirmDialog(
           iframe, "OK to close?", "Select an Option",
                               JOptionPane.YES_NO_OPTION);

           // if the user doesn't agree, veto the close
           if (result != JOptionPane.YES_OPTION)
              throw new PropertyVetoException(
            		     "User canceled close", event);
        }//end if
      }//end   etoableChange   
    });//end vetoableChangeListener

    // position frame
    int width = desktop.getWidth() / 2;
    int height = desktop.getHeight() / 2;
    iframe.reshape(nextFrameX, nextFrameY, width, height);

    iframe.show();
    // select the frame--might be vetoed
    try
    {
        iframe.setSelected(true);
    }
    catch (PropertyVetoException e)
    {}

    frameDistance = iframe.getHeight() -
                 iframe.getContentPane().getHeight();
    // compute placement for next frame
    nextFrameX += frameDistance;
    nextFrameY += frameDistance;
    if (nextFrameX + width > desktop.getWidth())
    	    nextFrameX = 0;
    if (nextFrameY + height > desktop.getHeight())
    	    nextFrameY = 0;
  }//end of createInternalFrame               //line 177
  /**
  Cascades the non-iconified internal 
  frames of the desktop.
  */
  public void cascadeWindows()              //line 182
  {
    int x = 0;
    int y = 0;
    int width = desktop.getWidth() / 2;
    int height = desktop.getHeight() / 2;

    for (JInternalFrame frame : desktop.getAllFrames())
    {
     if (!frame.isIcon())
     {
       try
       {
         // try to make maximized frames resizable
    	 //this might be vetoed
         frame.setMaximum(false);
         frame.reshape(x, y, width, height);

         x += frameDistance;
         y += frameDistance;
         // wrap around at the desktop edge
         if (x + width > desktop.getWidth()) x = 0;
         if (y + height > desktop.getHeight()) y = 0;
       }//end try
       catch (PropertyVetoException e)
       {}
      }//end if
    }//end for
  }//end cascadeWindows                   //line 210 
  /**
  Tiles the non-iconified internal 
  frames of the desktop.
  */
  public void tileWindows()                //line 215
  {
    // count frames that aren't iconized
    int frameCount = 0;
    for (JInternalFrame frame : desktop.getAllFrames())
       if (!frame.isIcon()) frameCount++;
    if (frameCount == 0) return;

    int rows = (int) Math.sqrt(frameCount);
    int cols = frameCount / rows;
    int extra = frameCount % rows;
    // number of columns with an extra row
    int width = desktop.getWidth() / cols;
    int height = desktop.getHeight() / rows;
    int r = 0;
    int c = 0;
    for (JInternalFrame frame : desktop.getAllFrames())
    {
      if (!frame.isIcon())
      {
        try
        {
         frame.setMaximum(false);
         frame.reshape(c * width, r * height, width, height);
         r++;
         if (r == rows)
         {
           r = 0;
           c++;
           if (c == cols - extra)
           {
              // start adding an extra row
              rows++;
              height = desktop.getHeight() / rows;
           }//enf if
          }//end if
         }//end try
         catch (PropertyVetoException e)
         {}
       }//end if
     }//end for
   }//end tileWindows                              //line 256 
  /**
   Brings the next non-iconified internal 
   frame to the front.
  */
  public void selectNextWindow()                   //line  261
  {
    JInternalFrame[] frames = desktop.getAllFrames();
    for (int i = 0; i < frames.length; i++)
    {
      if (frames[i].isSelected())
      {
        // find next frame that isn't an
    	// icon and can be selected
        int next = (i + 1) % frames.length;
        while (next != i)
        {
          if (!frames[next].isIcon())
          {
            try
            {
             // all other frames are icons or veto selection
             frames[next].setSelected(true);
             frames[next].toFront();
             frames[i].toBack();
                 return;
            }
            catch (PropertyVetoException e)
            {}
          }
          next = (next + 1) % frames.length;
        }//end while
      }//end if
    }//end for
  }//end selectNextWindow                      //line 290
}//end class                                   //line


