import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

public class JListFrame extends JFrame 
{
   // list to hold color names
   private JList colorJList;
   // list to copy color names into
   private JList copyJList; 
   // button to copy selected names
   private JButton copyJButton; 
   private final String colorNames[] = { "Black",   //line 17
		   "Blue", "Cyan", "Dark Gray", "Gray", "Green",
		   "Light Gray", "Magenta", "Orange",
            "Pink", "Red", "White", "Yellow" };

   //  constructor
   public JListFrame()                              //line 18 
   {
     super( "Multiple Selection Lists" );
     setLayout( new FlowLayout() ); // set frame layout
     // holds names of all colors
     colorJList = new JList( colorNames );          //line 23
     colorJList.setVisibleRowCount( 5 ); // show five rows
     colorJList.setSelectionMode(                              
     ListSelectionModel.MULTIPLE_INTERVAL_SELECTION );//line 26
     // add list with scrollpane
     add( new JScrollPane( colorJList ) ); 
     // create copy button
     copyJButton = new JButton( "Copy >>>" ); 
     copyJButton.addActionListener(
     new ActionListener() // anonymous inner class   //line 32
     {
        // handle button event
       public void actionPerformed( ActionEvent event )
       {
         // place selected values in copyJList
         copyJList.setListData(colorJList.getSelectedValues());     
       } // end method actionPerformed
     } // end anonymous inner class
	); // end call to addActionListener                 //line 41
     // add copy button to JFrame
    add( copyJButton );
 // create list to hold copied color names
    copyJList = new JList();                            // line 45
    copyJList.setVisibleRowCount( 5 ); // show 5 rows
    copyJList.setFixedCellWidth( 100 ); // set width  
    copyJList.setFixedCellHeight( 15 ); // set height 
    copyJList.setSelectionMode(                       
    ListSelectionModel.SINGLE_INTERVAL_SELECTION );
 // add list with scrollpane
    add( new JScrollPane( copyJList ) );         //line 52
  } // end of constructor                        //line 53
} // end class 







