import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
public class ComboBoxFrame extends JFrame
{
	private static final int WIDTH = 300; 
	private static final int HEIGHT = 200; 
	private static final int FONT_SIZE = 18; 
	private JComboBox testCombo; 
	private JLabel testLabel;
	
	public ComboBoxFrame()
	{
		setTitle("ComboBox Frame");
		setSize(WIDTH, HEIGHT);
		//ad the sample text label
		testLabel = new JLabel("This is a sample text");
		testLabel.setFont(new Font("Serif", Font.PLAIN, FONT_SIZE));
		add(testLabel, BorderLayout.CENTER);
		
		testCombo = new JComboBox();
		testCombo.setEditable(true);
		testCombo.addItem("Serif");
		testCombo.addItem("ScanSerif");
		testCombo.addItem("Monospaced");
		testCombo.addItem("Dialog");
		testCombo.addItem("DialogInput");
		//the comboBox listener change the font 
		
		testCombo.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent event)
			{
				testLabel.setFont(new Font((String) testCombo.getSelectedItem(), Font.PLAIN, FONT_SIZE ));
			}
			
		});
		
		JPanel comboPanel = new JPanel();
		comboPanel.add(testCombo);
		add(comboPanel, BorderLayout.SOUTH);
	}
}
