import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.JCheckBox;
public class CheckBoxFrame extends JFrame
{
	private JTextField textField; // displays text in changing fonts
	private JCheckBox boldJCheckBox; // to select/deselect bold    
	private JCheckBox italicJCheckBox; // to select/deselect italic
	
	// CheckBoxFrame constructor adds JCheckBoxes to JFrame
	 public CheckBoxFrame()
	 {
	     super( "JCheckBox Test" );
	     setLayout( new FlowLayout() ); // set frame layout
	
	     // set up JTextField and set its font
	     textField = new JTextField( "Watch the font style change", 20 );
	     textField.setFont( new Font( "Serif", Font.PLAIN, 14 ) );
	     add( textField ); // add textField to JFrame
	
	     boldJCheckBox = new JCheckBox( "Bold" ); // create bold checkbox
	     italicJCheckBox = new JCheckBox( "Italic" ); // create italic   
	     add( boldJCheckBox ); // add bold checkbox to JFrame
	     add( italicJCheckBox ); // add italic checkbox to JFrame
	
	     // register listeners for JCheckBoxes           
	     CheckBoxHandler handler = new CheckBoxHandler();
	     boldJCheckBox.addItemListener( handler );       
	     italicJCheckBox.addItemListener( handler );     
	 } // end CheckBoxFrame constructor
	
	  // private inner class for ItemListener event handling
	  private class CheckBoxHandler implements ItemListener         //line 37
	  {
	     private int valBold = Font.PLAIN; // controls bold font style
	     private int valItalic = Font.PLAIN; // controls italic font style
	
	     // respond to checkbox events                  
	     public void itemStateChanged( ItemEvent event )
	     {
	        // process bold checkbox events
	        if ( event.getSource() == boldJCheckBox )         //line 46
	           valBold = boldJCheckBox.isSelected() ? Font.BOLD : Font.PLAIN;
	
	           // process italic checkbox events
	        if ( event.getSource() == italicJCheckBox )       //line 50
	           valItalic = italicJCheckBox.isSelected() ? Font.ITALIC : Font.PLAIN;
	
	           // set text field font
	        textField.setFont(new Font( "Serif", valBold + valItalic, 16 ) );
	        } // end method itemStateChanged                            //line 57
	  } // end private inner class CheckBoxHandler
} // end class CheckBoxFrame



