/**
 * @license jquery.panzoom.js v1.2.1
 * Updated: Tue Jun 25 2013
 * Add pan and zoom functionality to any element
 * Copyright (c) 2013 timmy willison
 * Released under the MIT license
 * https://github.com/timmywil/jquery.panzoom/blob/master/MIT-License.txt
 */
(function(t,e){"function"==typeof define&&define.amd?define(["jquery"],e):e(t.jQuery)})(this,function(t){"use strict";var e={props:["touches","pageX","pageY"],filter:function(t,e){var n;return!e.pageX&&e.touches&&(n=e.touches[0])&&(t.pageX=n.pageX,t.pageY=n.pageY),t}};t.each(["touchstart","touchmove","touchend"],function(n,i){t.event.fixHooks[i]=e});var n="__pz__",i=Array.prototype.slice,a=/([A-Z])/g,s=/^http:[\w\.\/]+svg$/,o="(\\-?[\\d\\.e]+)",r="\\,?\\s*",h=RegExp("^matrix\\("+o+r+o+r+o+r+o+r+o+r+o+"\\)$"),c=function(e,i){1!==e.nodeType&&t.error("Panzoom called on non-Element node"),t.contains(document,e)||t.error("Panzoom element must be attached to the document");var o=t.data(e,n);if(o)return o;if(!(this instanceof c))return new c(e,i);this.options=i=t.extend({},c.defaults,i),this.elem=e;var r=this.$elem=t(e);this.$parent=r.parent(),this.isSVG=s.test(e.namespaceURI)&&"svg"!==e.nodeName.toLowerCase(),this.panning=!1,this._buildTransform(),this._transform=t.cssProps.transform.replace(a,"-$1").toLowerCase(),this._buildTransition(),this._buildContain();var h=t(),u=this;return t.each(["$zoomIn","$zoomOut","$zoomRange","$reset"],function(t,e){u[e]=i[e]||h}),this.enable(),t.data(e,n,this),this};return c.rmatrix=h,c.defaults={eventNamespace:".panzoom",transition:!0,cursor:"move",disablePan:!1,disableZoom:!1,increment:.3,minScale:.4,maxScale:5,duration:200,easing:"ease-in-out",contain:!1},c.prototype={constructor:c,instance:function(){return this},enable:function(){this._unbind(),this._initStyle(),this._bind(),this.disabled=!1},disable:function(){this.disabled=!0,this._resetStyle(),this._unbind()},isDisabled:function(){return this.disabled},destroy:function(){this.disable(),t.removeData(this.elem,n)},reset:function(t){var e=this.setMatrix(this._origTransform,{animate:"boolean"!=typeof t||t,range:!0});this._trigger("reset",e)},resetZoom:function(t){this._resetParts([0,3],t)},resetPan:function(t){this._resetParts([4,5],t)},getTransform:function(){var e=this.elem,n=t.style(e,"transform");return this.isSVG&&!n?n=t.attr(e,"transform"):"none"===n||h.test(n)||(n=t.style(e,"transform",t.css(e,"transform"))),n||"none"},getMatrix:function(t){var e=h.exec(t||this.getTransform());return e&&e.shift(),e||[1,0,0,1,0,0]},setMatrix:function(e,n){if(!this.disabled){if(n||(n={}),"string"==typeof e&&(e=this.getMatrix(e)),"boolean"==typeof n.contain?n.contain:this.options.contain){var i=this.container,a=this.dimensions;e[4]=Math.min(Math.max(e[4],-a.left),i.width-a.width-a.left),e[5]=Math.min(Math.max(e[5],-a.top),i.height-a.height-a.top)}return"skip"!==n.animate&&this.transition(!n.animate),n.range&&this.$zoomRange.val(e[0]),t[this.isSVG?"attr":"style"](this.elem,"transform","matrix("+e.join(",")+")"),n.silent||this._trigger("change",e),e}},isPanning:function(){return this.panning},transition:function(e){var n=e||!this.options.transition?"none":this._transition;t.style(this.elem,"transition",n)},pan:function(t,e,n){n||(n={});var i=n.matrix;i||(i=this.getMatrix()),n.relative?(i[4]=+i[4]+t,i[5]=+i[5]+e):(i[4]=t,i[5]=e),this.setMatrix(i,n),n.silent||this._trigger("pan",t,e)},zoom:function(t,e){var n=!1,i=this.options;if(!i.disableZoom){"object"==typeof t?e=t:e||(e={});var a=this.getMatrix(),s=e.middle;s&&(a[4]=+a[4]+(s.pageX===a[4]?0:s.pageX>a[4]?1:-1),a[5]=+a[5]+(s.pageY===a[5]?0:s.pageY>a[5]?1:-1)),"number"!=typeof t&&(t=+a[0]+i.increment*(t?-1:1),n=!0),t>i.maxScale?t=i.maxScale:i.minScale>t&&(t=i.minScale),a[0]=a[3]=t,this.setMatrix(a,{animate:"boolean"==typeof e.animate?e.animate:n,range:!e.noSetRange}),e.silent||this._trigger("zoom",t,e)}},option:function(e,n){var i;if(!e)return t.extend({},this.options);if("string"==typeof e){if(1===arguments.length)return this.options[e];i={},i[e]=n}else i=e;this._setOptions(i)},_setOptions:function(e){var n=this;t.each(e,function(e,i){switch(e){case"disablePan":n._resetStyle();case"disableZoom":case"$zoomIn":case"$zoomOut":case"$zoomRange":case"$reset":case"onStart":case"onChange":case"onZoom":case"onPan":case"onEnd":case"onReset":case"eventNamespace":n._unbind()}switch(n.options[e]=i,e){case"disablePan":n._initStyle();case"disableZoom":case"$zoomIn":case"$zoomOut":case"$zoomRange":case"$reset":case"onStart":case"onChange":case"onZoom":case"onPan":case"onEnd":case"onReset":case"eventNamespace":n._bind();break;case"cursor":t.style(n.elem,"cursor",i);break;case"minScale":n.$zoomRange.attr("min",i);break;case"maxScale":n.$zoomRange.attr("max",i);break;case"contain":n._buildContain();break;case"startTransform":n._buildTransform();break;case"duration":case"easing":n._buildTransition();case"transition":n.transition()}})},_initStyle:function(){this.options.disablePan||this.$elem.css("cursor",this.options.cursor);var e=this.$parent;if(e.length&&!t.nodeName(e[0],"body")){var n={overflow:"hidden"};"static"===e.css("position")&&(n.position="relative"),e.css(n)}},_resetStyle:function(){this.$elem.css({cursor:"",transition:""}),this.$parent.css({overflow:"",position:""})},_bind:function(){var e=this,n=this.options,i=n.eventNamespace,a="touchstart"+i+" mousedown"+i,s="touchend"+i+" click"+i,o={};if(t.each(["Start","Change","Zoom","Pan","End","Reset"],function(){var e=n["on"+this];t.isFunction(e)&&(o["panzoom"+this.toLowerCase()+i]=e)}),n.disablePan&&n.disableZoom||(o[a]=function(t){var i;if("touchstart"===t.type){if(i=t.touches){if(1===i.length&&!n.disablePan)return e._startMove(t.pageX,t.pageY),!1;if(2===i.length)return e._startMove(i),!1}}else if(!n.disablePan&&1===t.which&&null!=t.pageX&&null!=t.pageY)return e._startMove(t.pageX,t.pageY),!1}),this.$elem.on(o),!n.disableZoom){var r=this.$zoomIn,h=this.$zoomOut,c=this.$zoomRange,u=this.$reset;r.length&&h.length&&(r.on(s,function(t){t.preventDefault(),e.zoom()}),h.on(s,function(t){t.preventDefault(),e.zoom(!0)})),c.length&&(c.attr({min:n.minScale,max:n.maxScale,step:.05}).prop({value:this.getMatrix()[0]}),o={},o.mousedown=function(){e.transition(!0)},o["change"+i]=function(){e.zoom(+this.value,{noSetRange:!0})},c.on(o)),u.length&&u.on(s,function(t){t.preventDefault(),e.reset()})}},_unbind:function(){this.$elem.add(this.$zoomIn).add(this.$zoomOut).add(this.$reset).off(this.options.eventNamespace)},_buildTransform:function(){this._origTransform=this.options.startTransform||this.getTransform()},_buildTransition:function(){var t=this.options;this._transform&&(this._transition=this._transform+" "+t.duration+"ms "+t.easing)},_buildContain:function(){if(this.options.contain){var e=this.$parent;this.container={width:e.width(),height:e.height()};var n=this.elem,i=this.$elem;this.dimensions=this.isSVG?{left:n.getAttribute("x")||0,top:n.getAttribute("y")||0,width:n.getAttribute("width")||i.width(),height:n.getAttribute("height")||i.height()}:{left:t.css(n,"left",!0)||0,top:t.css(n,"top",!0)||0,width:i.width(),height:i.height()}}},_resetParts:function(t,e){for(var n=this.getMatrix(this._origTransform),i=this.getMatrix(),a=t.length;a--;)i[t[a]]=n[t[a]];this.setMatrix(i,{animate:"boolean"!=typeof e||e,range:!0})},_getDistance:function(t){var e=t[0],n=t[1];return Math.sqrt(Math.pow(Math.abs(n.pageX-e.pageX),2)+Math.pow(Math.abs(n.pageY-e.pageY),2))},_getMiddle:function(t){var e=t[0],n=t[1];return{pageX:(n.pageX-e.pageX)/2+e.pageX,pageY:(n.pageY-e.pageY)/2+e.pageY}},_trigger:function(t){this.$elem.triggerHandler("panzoom"+t,[this].concat(i.call(arguments,1)))},_startMove:function(e,n){var i,a,s,o,r,h=this,c=this.options,u=c.eventNamespace,m=t(document).off(u),g=this.getMatrix(),l={matrix:g,animate:"skip"},f=g.slice(0),p=+f[4],d=+f[5];this.transition(!0),this.panning=!0,this._trigger("start",e,n),1===arguments.length?(a=e,s=this._getDistance(a),o=+g[0],r=this._getMiddle(a),i=function(t){t.preventDefault(),a=t.touches;var e=h._getMiddle(a);h.pan(p+e.pageX-r.pageX,d+e.pageY-r.pageY,l);var n=h._getDistance(a)-s;h.zoom(n/300+o,{middle:e})}):i=function(t){t.preventDefault(),h.pan(p+t.pageX-e,d+t.pageY-n,l)},m.on("touchend"+u+" click"+u,function(e){e.preventDefault(),t(this).off(u),h.panning=!1,h._trigger("end",g,!!t(f).not(g).length)}).on("touchmove"+u+" mousemove"+u,i)}},t.fn.panzoom=function(e){var a,s,o,r;return"string"==typeof e?(r=[],s=i.call(arguments,1),this.each(function(){a=t.data(this,n),a?"_"!==e.charAt(0)&&"function"==typeof(o=a[e])&&void 0!==(o=o.apply(a,s))&&r.push(o):r.push(void 0)}),r.length?1===r.length?r[0]:r:this):this.each(function(){new c(this,e)})},c});