##############Driver Program to test ####################
from graphAdjMapModule import Graph
def create_graph(sequence, is_directed=False):

    G = Graph(directed=is_directed)
    weight_mapping = {}

    if len(sequence[0]) == 3:
        weighted = True
    else:
        weighted = False

    for edge in sequence:
        source, destination = edge[0:2]
        try:
            source_vertex = G.insert_vertex(source)
        except Exception:
            source_vertex = G.get_vertex(source)

        try:
            destination_vertex = G.insert_vertex(destination)
        except Exception:
            destination_vertex = G.get_vertex(destination)

        new_edge = G.insert_edge(source_vertex,
                                 destination_vertex,
                                 str(source) + str(destination))
        if weighted:
            weight_mapping[new_edge] = edge[2]
        else:
            weight_mapping[new_edge] = 1

    return G, weight_mapping


if __name__ == '__main__':

    # undirected example
    E = [('a', 'b'), ('b', 'c'), ('a', 'c')]
    G, _ = create_graph(E)
    print('Undirected G=(V,E) with V=(a,b,c) and E={(a,b),(b,c),(a,c)}.')
    print('Is the graph directed?: ' + str(G.is_directed()))
    a = G.get_vertex('a')
    print('Incident edges to: ' + a.element())
    for edge in G.incident_edges(a):
        print(edge.element())
    print('Adjacent vertices to: ' + a.element())
    x = G.adjacent_vertices(a, outgoing=True)
    for vertex in x:
        print(vertex.element())
    print('Deleting vertex a.')
    G.delete_vertex(a)
    print('Vertices count of G: ' + str(G.vertex_count()))
    for vertex in G.vertices():
        print(vertex.element())
    print('Edges count of G: ' + str(G.edges_count()))
    for edge in G.edges():
        print(edge.element())
    # =========================================================================
    # =========================================================================
    # =========================================================================
    # directed example
    E = [('a', 'b'), ('b', 'c'), ('a', 'c')]
    G, _ = create_graph(E)
    print('Undirected G=(V,E) with V=(a,b,c) and E={(a,b),(b,c),(a,c)}.')
    print('Is the graph directed?: ' + str(G.is_directed()))
    a = G.get_vertex('a')
    print('Is the graph directed?: ' + str(G.is_directed()))
    print('Incident edges to: ' + a.element())
    for edge in G.incident_edges(a):
        print(edge.element())
    print('Adjacent vertices to: ' + a.element())
    x = G.adjacent_vertices(a, outgoing=True)
    for vertex in x:
        print(vertex.element())
    print('Deleting vertex a.')
    G.delete_vertex(a)
    print('Vertices count of G: ' + str(G.vertex_count()))
    for vertex in G.vertices():
        print(vertex.element())
    print('Edges count of G: ' + str(G.edges_count()))
    for edge in G.edges():
        print(edge.element())
