# Python code to implement iterative Binary 
# Search. 

# It returns location of x in given array arr 
# if present, else returns -1
import numpy as np
def binarySearch(arr, r, h, item): 

	while r <= h: 

		mid = int((r + h) /2) 
		
		# Check if x is present at mid 
		if arr[mid] == item: 
			return mid 

		# If x is greater, ignore left half 
		elif arr[mid] < item: 
			r = mid + 1

		# If x is smaller, ignore right half 
		else: 
			h = mid - 1
	
	# If we reach here, then the element 
	# was not present 
	return -1


# Test array 
arr = np.array([ 2, 3, 4, 10, 40 ]) 
item = 10

# Function call 
result = binarySearch(arr, 0, len(arr)-1, item) 

if result != -1: 
	print ("Element is present at index % d" % result) 
else: 
	print ("Element is not present in array")
