##### File binTree.py   ##################   
##########  driver program  ##############
from binTreeModule import binTree
def menu():
    print()
    print("1. Insert data into the tree")
    print("2. Inorder traversal of the tree")
    print("3. preorder traversal of the tree")
    print("4. Postorder traversal of the tree")
    print("5. Find the minimum key in the tree")
    print("6. Find the maximum key in the tree")
    print("7. Search a key in the tree")
    print("8. Size of tree")
    print("9. Delete a key from the tree") 
    print("10. Exit from the program")
    choice = int(input("Enter your selection: "))
    return choice
#---------------------------------------
def inputKey():
    key = int(input("Enter a key: "))
    return key
#---------------------------------------
bt = binTree()
while True:
    c = menu()
    if c == 1:
        item = inputKey()
        btNode = bt.treeNode(item)
        bt.insertNode(btNode)
    elif c == 2:
        print("Inorder traversal is: ", end = " ")
        bt.inorder(bt.root)
    elif c == 3:
        print("Preorder traversal is: ", end = " ")
        bt.preorder(bt.root)
    elif c == 4:
        print("Postorder traversal is: ", end = " ")
        bt.postorder(bt.root)
    elif c == 5:
        minKey = bt.findMin()
        print("Min value is: ", minKey)
    elif c == 6:
        maxKey = bt.findMax()
        print("Max value is: ", maxKey)
    elif c == 7:
        item = inputKey()
        found = bt.searchKey(item)
        if found:
            print("The value ", item, " is found")
        else:
            print("The value ", item, " not found")
    elif c == 8:
        print("Tree size is :", bt.treeSize())
    elif c == 9:
        item = inputKey()
        found = bt.deleteNode(item)
        if found:
            print("Node deleted")
        else:
            print("Node not found")
    elif c == 10:
        break
