#implementation of the queue using circular array
from array import array
class cirArray:
    def __init__(self, maxSize):
        self.count = 0
        self.front = 0
        self.back = maxSize - 1
        self.qArray = array('i', [0] * maxSize)
    #----------------------------
    def isEmpty(self):
        return self.count == 0
    #----------------------------
    def isFull(self):
        return self.count == len(self.qArray)
    #----------------------------
    def length(self):
        return self.count
    #----------------------------
    def enqueue(self, item, overflow):
        if self.isFull():
            overflow = True
        else:
            overflow = False
            maxSize = len(self.qArray)
            self.back = (self.back + 1) % maxSize
            self.qArray[self.back] = item
            self.count += 1
        return overflow
    #----------------------
    def dequeue(self, item , underflow):
        if self.isEmpty():
            underflow = True
        else:
            underflow = False
            item = self.qArray[self.front]
            maxSize = len(self.qArray)
            self.front = (self.front + 1) % maxSize
            return item , underflow
    def printQueue(self):
        for i in range(self.front, self.count):
            print(self.qArray[i])
        
    #--------------------------------
