class circularLinkedList(object):
    class circularNode(object):
        def __init__(self, data, next = None):
            self.info = data
            self.next = next
        def getNext(self):
            return self.next
        def setNext(self, ptr):
            self.next = ptr
        def getInfo(self):
            return self.info
        def setInfo(self, data):
            self.info = data
    #-----------------------
    def __init__(self):
        self.listPtr = None
        self.size = 0
    #-----------------------     
    def __del__(self):
        current = self.listPtr
        while current:
            nextPtr = current.getNext()
            del current
            current = nextPtr
    #-----------------------
    def isEmpty(self):
        return self.listPtr == None
    def getSize(self):
        return self.size
    #----------------------------
    def insertAtEnd(self, newPtr):
        if self.isEmpty(): #A special case
            newPtr.next = newPtr
        else:
            newPtr.next = self.listPtr.next
            self.listPtr.next = newPtr
        self.listPtr = newPtr
        self.size += 1
    #------------------------
    def insertAtFirst(self, newPtr):
        if self.isEmpty(): #A special case
            newPtr.next = newPtr
            self.listPtr = newPtr
        else:
            newPtr.next = self.listPtr.next
            self.listPtr.next = newPtr
        self.size += 1
    #-----------------------------------
    def searchNode(self, item):
        if self.isEmpty() != True:
          ptr = self.listPtr
          found = False
          while ptr.next != self.listPtr and found is False:
            if item == ptr.getInfo():
                found = True
            else:
                ptr = ptr.next
          return ptr
        
    def deleteNode(self, item):
        if self.isEmpty() != True:
            ptr = self.listPtr.next
            pre = self.listPtr.next
            found = False
            while found is False:
                if item == ptr.getInfo():
                    found = True
                else:
                    pre = ptr
                    ptr = ptr.next
                    if pre == self.listPtr:
                        break
            if found:
                if ptr == ptr.next:       # Only one node
                      del ptr
                      self.listPtr = None
                elif ptr == self.listPtr: # Node is the last node
                     pre.next = self.listPtr.next
                     self.listPtr = pre
                     del ptr
                elif ptr == self.listPtr.next: # Node is the first node
                     self.listPtr.next = ptr.next
                     del ptr
                else:    #node is in the middle
                     pre.next = ptr.next
                     del ptr
                self.size -= 1
            return found
    #-----------------------
    def traverse(self):
        if self.isEmpty() != True:
            current = self.listPtr 
            while (True):
                current = current.next 
                print(current.getInfo())
                if current == self.listPtr:
                    break 
    #---------------------------------
