class binTree:
    class treeNode:
        def __init__(self, data):
           self.key = data
           self.left = None
           self.right = None
    #------------------------------------
    def __init__(self):
        self.root = None
        self.size = 0
    #------------------------------------
    def isEmpty(self):
        return self.root is None
    #------------------------------------
    def treeSize(self):
        return self.size
    #------------------------------------
    def insertNode(self, newNode):
        if self.isEmpty():
            self.root = newNode
            self.size += 1
        else:
            ptr = self.root
            while ptr:
                if newNode.key > ptr.key: #insert into right subtree
                    if ptr.right != None:
                        ptr = ptr.right
                    else:
                        ptr.right = newNode
                        break
                else:   #insert into the left subtrt
                    if ptr.left != None:
                        ptr = ptr.left
                    else:
                        ptr.left = newNode
                        break
            self.size += 1
    #---------------------------------------
    def inorder(self, nodePtr):
        if nodePtr:
            self.inorder(nodePtr.left)
            print(nodePtr.key, end = " ")
            self.inorder(nodePtr.right)
    #--------------------------------------
    def postorder(self, nodePtr):
        if (nodePtr):
            self.postorder(nodePtr.left)
            self.postorder(nodePtr.right)
            print(nodePtr.key, end = "  ")
    #-------------------------------------

    def preorder(self, nodePtr):
        if nodePtr:
            print(nodePtr.key, end = "  ")
            self.preorder(nodePtr.left)
            self.preorder(nodePtr.right)
    #--------------------------------------
    def findMin(self):
        if self.isEmpty() is not True:
            nodePtr = self.root
            while nodePtr.left:
                nodePtr = nodePtr.left
        return nodePtr.key
    #--------------------------------------
    def findMax(self):
        if self.isEmpty() is not True:
            nodePtr = self.root
            while nodePtr.right:
                nodePtr = nodePtr.right
        return nodePtr.key
    #---------------------------------------
    def searchKey(self, searchItem):
        found = False
        if self.isEmpty() is not True:
            current = self.root
            while current and found is False:
                if current.key == searchItem:
                    found = True
                elif searchItem < current.key:
                    current = current.left
                else:
                    current = current.right
        return found
    #--------------------------------------
    def deleteNode(self, item):
        x = parent = None
        found = False
        found, x, parent = self.findForDelete(item, found, x, parent)
        if found is False:
            return found
        if (x.left != None) and (x.right != None):
            # x has 2 childern, find its successor
            xSucc = x.right
            parent = x
            while xSucc.left is not None: #descend left
                parent = xSucc
                xSucc = xSucc.left
            #Move content of xSucc to x and change x
            #to point to successor, which be deleted
            x.key = xSucc.key 
            x = xSucc
        #end of if
        subtree = x.left
        if subtree == None:
            subtree = x.right
        if parent == None:    #root being deleted
            self.root = subtree
        elif parent.left == x: #left child of parent
            parent.left = subtree
        else:    #right
            parent.right = subtree
        del x
        return found
            
            
    #--------------------------------------
    def findForDelete(self, item, found, locPtr, parent):
        locPtr = self.root
        parent = None
        found = False
        while True:
            if found is True or locPtr == None:
                return (found, locPtr, parent)
            if item < locPtr.key:  #descend left
                parent = locPtr
                locPtr = locPtr.left
            elif item > locPtr.key:  #descend right
                parent = locPtr
                locPtr = locPtr.right
            else:
                found = True
        return (found, locPtr, parent)
    #---------------------------------------




        
         
    











            
                    
    
