package com.example.ghomi.chapter4_2;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.content.Context;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;
import android.widget.CheckedTextView;
import android.util.SparseBooleanArray;

public class MainActivity extends AppCompatActivity {
    ListView listview;
    String[] foodList;
    Context context;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        context = this;
        listview = (ListView)findViewById(R.id.listView);
        //string array
        String[] foodList = {"pizza", "burger", "chocolate", "ice-cream", "banana", "apple"};
        // set adapter for listview
        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, R.layout.list_item, foodList);
        listview.setAdapter(adapter);
        listview.setItemsCanFocus(false);
        // we want multiple clicks
        listview.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);
        listview.setOnItemClickListener(new CheckBoxClick());
    }

    public class CheckBoxClick implements OnItemClickListener{
    @Override
    public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
       // TODO Auto-generated method stub
       CheckedTextView ctv = (CheckedTextView) arg1;
       if(ctv.isChecked())
         Toast.makeText(MainActivity.this, "now it is checked", Toast.LENGTH_SHORT).show();
       else
         Toast.makeText(MainActivity.this, "now it is unchecked", Toast.LENGTH_SHORT).show();
       }
    }

    public void onClickSubmit(View v) {
        SparseBooleanArray checked = listview.getCheckedItemPositions();
        int num = 0; //number of selected item
        int sum = 0; //total price
        for (int i = 0; i < listview.getAdapter().getCount(); i++) {
          if (checked.get(i)) {
               num ++;
               switch(i){
                   case 0 :
                      sum += 20000;
                      break;
                   case 1 :
                      sum += 6000;
                      break;
                   case 2 :
                      sum += 4000;
                      break;
                   case 3 :
                      sum += 2000;
                      break;
                   case 4 :
                      sum += 15000;
                      break;
                   case 5 :
                      sum += 12000;
                      break;
               } //end of switch
          } //end of if
        } //end of for
        String s = "";
        s =  " You selected " + Integer.toString(num)+ " items" ;
        s += "\n\r";
        s += "Price is :" + Integer.toString(sum);
        Toast.makeText(MainActivity.this, s, Toast.LENGTH_SHORT).show();
    }
}
