﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ch8_2
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        string fileName; // name of file
        string cutText;  //for text holding
        bool modified;   //file changed or not

        private bool saveAs1()
        {
            saveFileDialog1.Filter = "*.txt |*.txt";
            saveFileDialog1.Title = "Select File Name For Save";
            saveFileDialog1.FileName = fileName;
            saveFileDialog1.ShowDialog();
            fileName = saveFileDialog1.FileName;
            richTextBox1.SaveFile(fileName);

            return true;
        }
        private bool save1()
        {
            if (fileName == "")
                return saveAs1();
            else
            {
                modified = false;
                richTextBox1.SaveFile(fileName);
                return true;
            }
        }

        private bool saveChange()
        {
            bool saveCh = true;
            DialogResult code;
            code = MessageBox.Show("The Information " + fileName +
                " has changed,save?", "Save Dialog", MessageBoxButtons.YesNoCancel);
            if (code == DialogResult.Yes)
                saveCh = save1();
            if (code == DialogResult.Yes) 
                saveCh = false;
            return saveCh;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            richTextBox1.ContextMenuStrip = contextMenuStrip1;
            richTextBox1.Text = " ";
            fileName = "";
            modified = false;
            pasteToolStripMenuItem.Enabled = false;
            copyToolStripMenuItem.Enabled = false;
            clearToolStripMenuItem.Enabled = false;
            helpProvider1.HelpNamespace = "d:\\Csharp2012\\ch8\\help.html";

        }

        private void newToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (modified)
                saveChange();
            richTextBox1.Clear();
            modified = false;
            fileName = "";
            this.Text = "Notes-[Untitled]";
        }

        private void richTextBox1_TextChanged(object sender, EventArgs e)
        {
            modified = true;
            if (richTextBox1.SelectedText != "" || cutText != "")
            {
                cutToolStripMenuItem.Enabled = true;
                copyToolStripMenuItem.Enabled = true;
            }					
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "*.txt|*.txt";
            openFileDialog1.Title = "Select File Name For Open";
            openFileDialog1.FileName = fileName;
            openFileDialog1.ShowDialog();
            fileName = openFileDialog1.FileName;
            richTextBox1.LoadFile(fileName);
            this.Text = "Notes-" + fileName;
        }

        private void saveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (modified)
            {
                save1();
                modified = false;
            }
            this.Text = "Notes-" + fileName;
        }

        private void saveAsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (modified)
            {
                save1();
                modified = false;
            }
            this.Text = "Notes-" + fileName;
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (modified) 
                save1();
            Close();
        }

        private void cutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cutText = richTextBox1.SelectedText;
            richTextBox1.Cut();
            richTextBox1.SelectedText = "";
            pasteToolStripMenuItem.Enabled = true;
        }

        private void copyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cutText = richTextBox1.SelectedText;
            richTextBox1.Focus();
            richTextBox1.Copy();
            pasteToolStripMenuItem.Enabled = true;
            copyToolStripMenuItem.Enabled = false;
            cutToolStripMenuItem.Enabled = false;
            clearToolStripMenuItem.Enabled = false;
        }

        private void pasteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            richTextBox1.Paste();
            richTextBox1.Refresh();
            copyToolStripMenuItem.Enabled = false;
            cutToolStripMenuItem.Enabled = false;
            clearToolStripMenuItem.Enabled = false;
        }

        private void clearToolStripMenuItem_Click(object sender, EventArgs e)
        {
            richTextBox1.SelectedText = "";
            copyToolStripMenuItem.Enabled = false;
            cutToolStripMenuItem.Enabled = false;
            clearToolStripMenuItem.Enabled = false;
        }

        private void fontToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult result;
            result = fontDialog1.ShowDialog();
            if (result == DialogResult.OK)
                richTextBox1.Font = fontDialog1.Font;
        }

        private void colorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult result;
            result = colorDialog1.ShowDialog();
            if (result == DialogResult.OK)
                richTextBox1.BackColor = colorDialog1.Color;
        }

        private void readOnlyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            readOnlyToolStripMenuItem.Checked = !readOnlyToolStripMenuItem.Checked;
            richTextBox1.ReadOnly = !richTextBox1.ReadOnly;
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("You are writing program in C# .NET");
        }

        private void CSave_Click(object sender, EventArgs e)
        {
            saveToolStripMenuItem_Click(sender, e);
        }

        private void CCopy_Click(object sender, EventArgs e)
        {
            copyToolStripMenuItem_Click(sender, e);
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            aboutToolStripMenuItem_Click(this, e);
        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            colorToolStripMenuItem_Click(sender, e);
        }

        private void richTextBox1_SelectionChanged(object sender, EventArgs e)
        {
            if (richTextBox1.SelectedText != "")
            {
                cutToolStripMenuItem.Enabled = true;
                copyToolStripMenuItem.Enabled = true;
                clearToolStripMenuItem.Enabled = true;
            }
        }
    }
}
