﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ch7_6
{
    class ComplexNumber
    {
        private int real;
        private int imaginary;
        public ComplexNumber()
        {
            //Default constructor
        }
        public ComplexNumber(int a, int b)
        {
            Real = a;
            Imaginary = b;
        }
        public int Real
        {
            get
            {
                return real;
            }
            set
            {
                real = value;
            }
        }
        public int Imaginary
        {
            get
            {
                return imaginary;
            }
            set
            {
                imaginary = value;
            }
        }
        public override string ToString()
        {
            return "(" + real + (imaginary < 0 ? " - " + (imaginary * -1) :
                " + " + imaginary) + "i ) ";
        }
        public static ComplexNumber operator +(ComplexNumber x, ComplexNumber y)
        {
            return new ComplexNumber(x.Real + y.Real, x.Imaginary + y.Imaginary);
        }

        public static ComplexNumber operator -(ComplexNumber x, ComplexNumber y)
        {
            return new ComplexNumber(x.Real - y.Real, x.Imaginary - y.Imaginary);
        }
        public static ComplexNumber operator *(ComplexNumber x, ComplexNumber y)
        {
            return new ComplexNumber(
                x.real * y.real - x.imaginary - y.imaginary,
                x.Real * y.Imaginary + y.Real * x.Imaginary);
        }
    }
}
