﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ch6_8
{
    class SimpleTime
    {
        private int hour;
        private int minute;
        private int second;
        //Constructor with no parameters
        public SimpleTime()
        {
            SetTime(0, 0, 0);
        }
        //Constructor with one parameter
        public SimpleTime(int h)
        {
            SetTime(h, 0, 0);
        }
        //Constructor with two parameter
        public SimpleTime(int h, int m)
        {
            SetTime(h, m, 0);
        }
        //Constructor with three parameters
        public SimpleTime(int h, int m, int s)
        {
            SetTime(h, m, s);
        }
        // set time
        public void SetTime(int h, int m, int s)
        {
            Hour = h; // set the Hour property
            Minute = m; // set the Minute property
            Second = s; // set the Second property
        } // end method SetTime
        public int Hour
        {
            get
            {
                return hour;
            } // end get
            // make writing inaccessible outside the class
            private set
            {
                hour = ((value >= 0 && value < 24) ? value : 0);
            } // end set
        } // end property Hour
        // property that gets and sets the minute
        public int Minute
        {
            get
            {
                return minute;
            } // end get
            // make writing inaccessible outside the class
            private set
            {
                minute = ((value >= 0 && value < 60) ? value : 0);
            } // end set
        } // end property Minute
        // property that gets and sets the second
        public int Second
        {
            get
            {
                return second;
            } // end get
            // make writing inaccessible outside the class
            private set
            {
                second = ((value >= 0 && value < 60) ? value : 0);
            } // end set
        } // end property Second
        // convert to string in universal-time format (HH:MM:SS)
        public string ToUniversalString()
        {
            return string.Format(
               "{0:D2}:{1:D2}:{2:D2}", Hour, Minute, Second);
        } // end method ToUniversalString
        // convert to string in standard-time format (H:MM:SS AM or PM)
        public string ToStandardString()
        {
            return string.Format("{0}:{1:D2}:{2:D2} {3}",
               ((Hour == 0 || Hour == 12) ? 12 : Hour % 12),
               Minute, Second, (Hour < 12 ? "AM" : "PM"));
        } // end method ToStandardString
    }
}
