﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace ch10_3
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        private const int  Max_Number = 1000000;
        private FileStream input = null;
        private FileStream output = null;
        private randomAccessRecord record = new randomAccessRecord();
        private BinaryReader binaryInput;
        private BinaryWriter binaryOutput;

        private void clearTextBox()
        {
            textBox1.Clear();
            textBox2.Clear();
            textBox3.Clear();
            textBox4.Clear();
            listBox1.Items.Clear();
        }
        //***********************
        private void openFile()
        {
            if (File.Exists("student.rnd"))
                output = new FileStream("Student.rnd", FileMode.Open, FileAccess.Write);
            else
            {
                output = new FileStream("Student.rnd", FileMode.Create, FileAccess.Write);
                binaryOutput = new BinaryWriter(output);
                output.Seek((Max_Number - 1) * randomAccessRecord.SIZE, SeekOrigin.Begin);
                binaryOutput.Write(Max_Number);
            }
        }
        private void button1_Click(object sender, EventArgs e)
        {
            if (textBox1.Text != "")
            {
                int stno = Convert.ToInt32(textBox1.Text);
                openFile();
                binaryOutput = new BinaryWriter(output);
                if (stno > 0 && stno < Max_Number )
                {
                    output.Seek((stno - 1) * randomAccessRecord.SIZE, SeekOrigin.Begin);
                    binaryOutput.Write(stno);
                    record.fName = textBox2.Text;
                    record.lName = textBox3.Text;
                    record.Grade = Convert.ToDouble(textBox4.Text);
                    binaryOutput.Write(record.fName);
                    binaryOutput.Write(record.lName);
                    binaryOutput.Write(record.Grade);
                }
                else
                    MessageBox.Show("Invalid stNo");
                output.Close();
                clearTextBox();
            }
            else
                MessageBox.Show("Please enter stNo and try");
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (textBox1.Text != "")
            {
                input = new FileStream("Student.rnd", FileMode.Open, FileAccess.Read);
                binaryInput = new BinaryReader(input);
                int stno = Convert.ToInt32(textBox1.Text);
                if (stno > 0 && stno < Max_Number)
                {
                    input.Seek((stno - 1) * randomAccessRecord.SIZE, 0);
                    record.StNo = binaryInput.ReadInt32();
                    record.fName = binaryInput.ReadString();
                    record.lName = binaryInput.ReadString();
                    record.Grade = binaryInput.ReadDouble();
                    if (record.StNo == 0)
                        MessageBox.Show("Record not found");
                    else
                    {
                        textBox2.Text = record.fName;
                        textBox3.Text = record.lName;
                        textBox4.Text = record.Grade.ToString();
                    }
                }
                else
                    MessageBox.Show("Invalid stNo");
                input.Close();
            }
            else
                MessageBox.Show("Please enter stNo");
        }

        private void button3_Click(object sender, EventArgs e)
        {
            input = new FileStream("Student.rnd", FileMode.Open, FileAccess.Read);
            binaryInput = new BinaryReader(input);
            double sum = 0;
            int count = 0;
            listBox1.Items.Clear();
            listBox1.Items.Add("List of students : ");
            for (int i = 0; i < Max_Number ; i++)
            {

                input.Seek((i) * randomAccessRecord.SIZE, 0);
                record.StNo = binaryInput.ReadInt32();
                record.fName = binaryInput.ReadString();
                record.lName = binaryInput.ReadString();
                record.Grade = binaryInput.ReadDouble();
                if (record.StNo != 0)
                {
                    sum += record.Grade;
                    count++;
                    string result = record.StNo.ToString() + "\t" + record.fName + "\t" + record.lName + "\t" + record.Grade.ToString();
                    listBox1.Items.Add(result);
                }
            }
            listBox1 .Items .Add ("====================================");
            listBox1 .Items .Add ("Average is: " + Convert.ToString((sum / count)));
        }
    }
}
