Attribute VB_Name = "Module1"
Option Explicit
Declare Function GetPortByte Lib "io32.dll" (ByVal PortAddr As Integer) As Integer
Declare Function SetPortByte Lib "io32.dll" (ByVal PortAddr As Integer, ByVal PortVal As Byte) As Boolean

Public Sub Speaker(bOn As Boolean)
  Dim PortVal As Integer
  PortVal = GetPortByte(&H61)
  If bOn Then
    PortVal = PortVal Or 3
    PortVal = &H2F
 Else
   PortVal = PortVal And (Not 3)
End If
  SetPortByte &H61, PortVal
End Sub
' Speaker freq is set by setting divider in Intel
' 8253/8254 timer chip at port addresses $42 through $43
Public Sub SetFreq(ByVal hertz As Integer)
 Dim s As String
 s = Space(255)
 If hertz Then
    Dim divisor As Long
    divisor = 1193180 / hertz
    SetPortByte &H43, &HB6
    SetPortByte &H42, divisor Mod 256
    SetPortByte &H42, divisor \ 256
    Speaker True
Else
  Speaker False
End If
End Sub
Public Sub PlayFrequency(ByVal Frequency As Long)
 Dim clockTicks
 Dim loopCount
 clockTicks = 1193280 \ Frequency
'prepare for data
 SetPortByte 67, 182
'send data
 SetPortByte 66, clockTicks And &HFF
 SetPortByte 66, clockTicks \ 256
 'turn speaker on
 SetPortByte 97, GetPortByte(97) Or &H3
 For loopCount = 1 To 200
  DoEvents
 Next
'turn speaker off
 SetPortByte 97, GetPortByte(97) And &HFC
End Sub

