/* Filename:  hashmake.cpp

   Programmer:  E. Jafarnejad

   Date:  2006


   This program creates a hash table in a file.  It reads the data from
   the source text file hash.txt.  This file must contain an integer key on
   one line, followed by a string on the next, etc.  The file hash.dat is
   used to stored the hash table.  Use the accompanying readhash program
   to look up data that is in the hash table.

   To compile this program under Visual C++ and then run it, you will need to set up a project
   containing the following files:
   hashmake.cpp  itemtype.h   hash.h        table.h

   Tested with:
      Microsoft Visual C++ 6.0
      Microsoft Visual C++ .NET
      g++ under Linux
      bc in windows
*/

#include "fstream.h"
#include "d:\hash\hash.h"
#include "conio.h"
int main(void)
{
   ItemType Item;
   fstream Source;
   clrscr();
   HashTableClass HashTable('w', "hash.dat");

   Source.open("hash.txt", ios::in);
   if (Source.fail())
      Error("ERROR: Unable to open file hash.txt for input");

   Source >> Item.KeyField;
   while (! Source.eof())
   {
      Source >> Item.DataField;
      cout << "Inserting: " << Item.KeyField << "   " << Item.DataField
	 << endl;
      if (! HashTable.Insert(Item))
	 cout << "Warning:  unable to insert item with KeyField: "
	    << Item.KeyField << endl;
      Source >> Item.KeyField;
   }

   Source.close();
   getch();
   return 0;
   // HashTable destructor is automatically called
}


