int FixedTextBuffer :: Pack (const char * str)
// set the value of the next field of the buffer;
{

    // buffer is full or not packing mode
   if (NextField == NumFields || !Packing)
	return FALSE;
   int start = NextCharacter; // first byte to be packed
   int packSize = FieldSize[NextField]; // number bytes to be packed
   strncpy (&Buffer[start], str, packSize);
   NextCharacter += packSize;
   NextField ++;
   // if len < packSize, pad with blanks
   for (int i = start + packSize; i < NextCharacter; i ++)
	Buffer[start] = ' ';
   Buffer [NextCharacter] = 0; // make buffer look like a string
   if (NextField == NumFields) // buffer is full
   {
	Packing = FALSE;
	NextField = NextCharacter = 0;
   }
   return TRUE;
}
