int LengthTextBuffer :: Pack (const char * str, short size)
// set the value of the next field of the buffer;
// if size = -1 (default) use strlen(str) as length of field
{
  short len; // length of string to be packed
  if (size >= 0)
     len = size;
  else
     len = strlen (str);
  if (len > strlen(str)) // str is too short!
    return FALSE;
  int start = NextByte; // first character to be packed
  NextByte += (len + sizeof(len));
  if (NextByte > MaxBytes)
     return FALSE;
  memcpy (&Buffer[start], &len, sizeof(len));
  strncpy (&Buffer[start+sizeof(len)], str, len);
  BufferSize = NextByte;
  return TRUE;
}
