/* Filename:  table.h

   Programmer:  E. Jafarnejad
   Date : 2006

   This header file sets up TableBaseClass as an abstract base class for
   tables that are stored in a file.
*/

#include "fstream.h"
#include "d:\hash\itemtype.h"

class TableBaseClass
{
   public:
      virtual int Empty(void) const = 0;
      virtual int Insert(const ItemType & Item) = 0;
      virtual int Retrieve(KeyFieldType SearchKey, ItemType & Item) = 0;
   protected:
      fstream DataFile;   // the file stream for the table data
      long NumItems;      // number of records in the table
      char OpenMode;      // r or w (read or write) mode for the table
};


