int DelimTextBuffer :: Pack (const char * str, int size)
// set the value of the next field of the buffer;
// if size = -1 (default) use strlen(str) as Delim of field
{
  short len; // length of string to be packed
  if (size >= 0)
    len = size;
  else
    len = strlen (str);
  if (len > strlen(str)) // str is too short!
    return FALSE;
  int start = NextByte; // first character to be packed
  NextByte += len + 1;
  if (NextByte > MaxBytes)
    return FALSE;
  memcpy (&Buffer[start], str, len);
  Buffer [start+len] = Delim; // add delimeter
  BufferSize = NextByte;
  return TRUE;
}
