class DelimTextBuffer
// a buffer which holds delimited text fields.
// Fields can be packed into and extracted from a buffer.
{
   public:
     // construct with a maximum of maxFields
     DelimTextBuffer (char Delim = '|', int maxBytes = 1000);
     // construct with fields with delimeters
     void Clear (); // clear fields from buffer
     int Read (istream &);
     int Write (ostream &) const;
     // set the value of the next field of the buffer
     int Pack (const char *, int size = -1);
     // extract the value of the next field of the buffer
     int Unpack (char *);
     void Print (ostream &) const;  //print buffer size
     int Init (char delim, int maxBytes = 1000);
   private:
     char Delim;
     char DelimStr[2]; // zero terminated string for Delim
     char * Buffer; // character array to hold field values
     int BufferSize; // size of packed fields
     int MaxBytes; // maximum number of characters in the buffer
     int NextByte; // packing/unpacking position in buffer
};
