#ifndef PERSON_H
#define PERSON_H
#include <iostream.h>
#include "fixtext.h"
#include "lentext.h"
#include "deltext.h"
class Student
{
  public:
	// fields
	char FirstName [11];
	char LastName [12];
	char Course [12];
	char Stno [7];
	char Address [11];
	char ZipCode [10];
	//operations
	Student ();
	void Clear ();
	static int InitBuffer (FixedTextBuffer &);
	int Unpack (FixedTextBuffer &);
	int Pack (FixedTextBuffer &) const;
	static int InitBuffer (LengthTextBuffer &);
	int Unpack (LengthTextBuffer &);
	int Pack (LengthTextBuffer &) const;
	static int InitBuffer (DelimTextBuffer &);
	int Unpack (DelimTextBuffer &);
	int Pack (DelimTextBuffer &) const;
	void Print (ostream &);
};

#endif
Student::Student ()
{
  Clear ();
}

void Student::Clear ()
{
	// set each field to an empty string
	FirstName [0] = 0;
	LastName [0] = 0;
	Course [0] = 0;
	Stno [0] = 0;
	Address [0] = 0;
	ZipCode [0] = 0;
}

int Student::Pack (FixedTextBuffer & Buffer) const
{
 // pack the fields into a FixedTextBuffer,
 // return TRUE if all succeed, FALSE o/w
	int result;
	Buffer . Clear ();
	result = Buffer . Pack (FirstName);
	result = result && Buffer . Pack (LastName);
	result = result && Buffer . Pack (Course);
	result = result && Buffer . Pack (Stno);
	result = result && Buffer . Pack (Address);
	result = result && Buffer . Pack (ZipCode);
	return result;
}

int Student::Unpack (FixedTextBuffer & Buffer)
{
	Clear ();
	int result;
	result = Buffer . Unpack (FirstName);
	result = result && Buffer . Unpack (LastName);
	result = result && Buffer . Unpack (Course);
	result = result && Buffer . Unpack (Stno);
	result = result && Buffer . Unpack (Address);
	result = result && Buffer . Unpack (ZipCode);
	return result;
}

int Student::InitBuffer (FixedTextBuffer & Buffer)
// initialize a FixedTextBuffer to be used for students
{
	int result;
	result = Buffer . AddField (10); // FirstName [11];
	result = result && Buffer . AddField (11); // LastName [12];
	result = result && Buffer . AddField (11); // Course [16];
	result = result && Buffer . AddField (6); // Stno [7];
	result = result && Buffer . AddField (10);  // Address [11];
	result = result && Buffer . AddField (9); // ZipCode [10];
	return result;
}

int Student::Pack (LengthTextBuffer & Buffer) const
{// pack the fields into a FixedTextBuffer, return TRUE if all succeed, FALSE o/w
	int result;
	Buffer . Clear ();
	result = Buffer . Pack (FirstName);
	result = result && Buffer . Pack (LastName);
	result = result && Buffer . Pack (Course);
	result = result && Buffer . Pack (Stno);
	result = result && Buffer . Pack (Address);
	result = result && Buffer . Pack (ZipCode);
	return result;
}

int Student::Unpack (LengthTextBuffer & Buffer)
{
	int result;
	result = Buffer . Unpack (FirstName);
	result = result && Buffer . Unpack (LastName);
	result = result && Buffer . Unpack (Course);
	result = result && Buffer . Unpack (Stno);
	result = result && Buffer . Unpack (Address);
	result = result && Buffer . Unpack (ZipCode);
	return result;
}

Student::InitBuffer (LengthTextBuffer & Buffer)
// initialize a LengthTextBuffer to be used for Persons
{
	return TRUE;
}

int Student::Pack (DelimTextBuffer & Buffer) const
{ // pack the fields into a FixedTextBuffer,
  // return TRUE if all succeed, FALSE o/w
	int result;
	Buffer . Clear ();
	result = Buffer . Pack (FirstName);
	result = result && Buffer . Pack (LastName);
	result = result && Buffer . Pack (Course);
	result = result && Buffer . Pack (Stno);
	result = result && Buffer . Pack (Address);
	result = result && Buffer . Pack (ZipCode);
	return result;
}

int Student::Unpack (DelimTextBuffer & Buffer)
{
	int result;
	result = Buffer . Unpack (FirstName);
	result = result && Buffer . Unpack (LastName);
	result = result && Buffer . Unpack (Course);
	result = result && Buffer . Unpack (Stno);
	result = result && Buffer . Unpack (Address);
	result = result && Buffer . Unpack (ZipCode);
	return result;
}

Student::InitBuffer (DelimTextBuffer & Buffer)
// initialize a DelimTextBuffer to be used for Persons
{
	return TRUE;
}

void Student::Print (ostream & stream)
{
	stream << "Student:"
		<< "\tFirst Name '"<<FirstName<<"'\n"
		<< "\t Last Name '"<<LastName<<"'\n"
		<< "\t   Course '"<<Course<<"'\n"
		<< "\t      Stno '"<<Stno<<"'\n"
		<< "\t     Address '"<<Address<<"'\n"
		<< "\t  Zip Code '"<<ZipCode<<"'\n" <<flush;
}




