// length.h

#ifndef LENGTH_H
#define LENGTH_H

#include "iostream.h"
#include "varlen.h"

class LengthFieldBuffer: public VariableLengthBuffer
// a buffer which holds a length plus value fields.
// Record variables can be packed into and extracted from a buffer.
// 
// To use this class, create a LengthFieldBuffer variable and associate definitions with the fields.
// operations are provided to allow values to be associated with the fields (Pack)
//	and to fetch the values of fields (Unpack)
{  public:
	LengthFieldBuffer (int maxBytes = 1000); // construct with a maximum of maxFields
		// construct with fields of specific size
	LengthFieldBuffer (const LengthFieldBuffer & buffer) // copy constructor
	: VariableLengthBuffer (buffer) {}
	void Clear (); // clear fields from buffer
	int Pack (const void * field, int size = -1); // set the value of the next field of the buffer;
	int Unpack (void *field, int maxBytes = -1); // extract the value of the next field of the buffer
	void Print (ostream &) const;
 	int Init ();
   protected:
};

#endif
// lentext.cc
//class LengthFieldBuffer 

// public members

LengthFieldBuffer :: LengthFieldBuffer (int maxBytes)
 // construct with a maximum of maxFields
: VariableLengthBuffer (maxBytes)
{
	Init ();
}

void LengthFieldBuffer :: Clear ()
// clear fields from buffer
{
	VariableLengthBuffer::Clear ();
}

int LengthFieldBuffer :: Pack (const void* field, int size)
// set the value of the next field of the buffer;
// if size = -1 (default) use strlen(str) as length of field
// return number of bytes packed, -1 if error
{
	short len; // length of string to be packed
	if (size >= 0) len = size;
	else len = strlen ((char *) field);
	int start = NextByte; // first character to be packed
	NextByte += (len + sizeof(len));
	if (NextByte > MaxBytes) return -1;
	memcpy (&Buffer[start], &len, sizeof(len));
	memcpy (&Buffer[start+sizeof(len)], field, len);
	BufferSize = NextByte;
	return len;
}

int LengthFieldBuffer :: Unpack (void* field, int maxBytes)
// extract the value of the next field of the buffer
// return the number of bytes extracted, -1 if error
{
	short len; // length of packed string
	if (NextByte >= BufferSize) return -1; // no more fields
	int start = NextByte; // first character to be unpacked
	memcpy (&len, &Buffer[start], sizeof(len));
	if (maxBytes != -1 && len > maxBytes) return -1; // field too long
	NextByte += len + sizeof(len);
	if (NextByte > BufferSize) return -1;
	memcpy (field, &Buffer[start+sizeof(len)], len);
	if (maxBytes > len || maxBytes == -1)
		((char *)field) [len] = 0; // zero termination for string 
	return len;
}

void LengthFieldBuffer :: Print (ostream & stream) const
{
	stream << "Buffer has characters "<<MaxBytes<<" and Buffer Size "<<BufferSize<<endl;
}

// Protected members

int LengthFieldBuffer :: Init ()
 // construct with a maximum of maxFields
{
	Initialized = TRUE;
	Clear ();
	return TRUE;
}

