/* Filename:  table.h

   Programmer:  Br. David Carlson

   Date:  November 10, 1997
                                                                                
   Modified:  May 23, 1999 and June 27, 2000

   This header file sets up TableBaseClass as an abstract base class for
   tables that are stored in a file.
*/

#include "d:\btree\itemtype.h"


class TableBaseClass
{
   public:
      virtual int Empty() = 0;
      virtual int Insert(const ItemType & Item) = 0;
      virtual int Retrieve(KeyFieldType SearchKey, ItemType & Item) = 0;
   protected:
      fstream DataFile;   // the file stream for the table data
      long NumItems;      // number of records in the table
      char OpenMode;      // r or w (read or write) mode for the table
};

