#include "iostream.h"
#include "string.h"
#ifndef FALSE
#define FALSE (0)
#define TRUE (1)
#endif

class DelimTextBuffer
// a buffer which holds delimited text fields.
// Fields can be packed into and extracted from a buffer.
{
   public:
     // construct with a maximum of maxFields
     DelimTextBuffer (char Delim = '|', int maxBytes = 1000);
     // construct with fields with delimeters
     void Clear (); // clear fields from buffer
     int Read (istream &);
     int Write (ostream &) const;
     // set the value of the next field of the buffer
     int Pack (const char *, int size = -1);
     // extract the value of the next field of the buffer
     int Unpack (char *);
     void Print (ostream &) const;  //print buffer size
     int Init (char delim, int maxBytes = 1000);

     int DRead (istream & stream, int recref);

   private:
     char Delim;
     char DelimStr[2]; // zero terminated string for Delim
     char * Buffer; // character array to hold field values
     int BufferSize; // size of packed fields
     int MaxBytes; // maximum number of characters in the buffer
     int NextByte; // packing/unpacking position in buffer
};
//******************************
DelimTextBuffer :: DelimTextBuffer (char delim, int maxBytes)
 // construct with a maximum of maxFields
{
  Init (delim, maxBytes);
}

void DelimTextBuffer :: Clear ()
// clear fields from buffer
{
  NextByte = 0;
  BufferSize = 0;
}

int DelimTextBuffer :: Read (istream & stream)
{
  Clear ();
  int x = stream.tellg();
  stream . read ((char*)&BufferSize, sizeof(BufferSize));
  if (stream.fail())
      return FALSE;
  if (BufferSize > MaxBytes)
      return FALSE; // buffer overflow
  stream . read (Buffer, BufferSize);
  //return stream . good ();
  return x;

}


int DelimTextBuffer :: Write (ostream & stream) const
{
  stream . write ((char*)&BufferSize, sizeof(BufferSize));
  stream . write (Buffer, BufferSize);
  return stream . good ();
}

int DelimTextBuffer :: Pack (const char * str, int size)
// set the value of the next field of the buffer;
// if size = -1 (default) use strlen(str) as Delim of field
{
  short len; // length of string to be packed
  if (size >= 0)
    len = size;
  else
    len = strlen (str);
  if (len > strlen(str)) // str is too short!
    return FALSE;
  int start = NextByte; // first character to be packed
  NextByte += len + 1;
  if (NextByte > MaxBytes)
    return FALSE;
  memcpy (&Buffer[start], str, len);
  Buffer [start+len] = Delim; // add delimeter
  BufferSize = NextByte;
  return TRUE;
}

int DelimTextBuffer :: Unpack (char * str)
// extract the value of the next field of the buffer
{
  int len = -1; // length of packed string
  int start = NextByte; // first character to be unpacked
  for (int i = start; i < BufferSize; i++)
    if (Buffer[i] == Delim)
    {
       len = i - start;
       break;
    }
    if (len == -1)
       return FALSE; // delimeter not found
    NextByte += len + 1;
    if (NextByte > BufferSize)
       return FALSE;
    strncpy (str, &Buffer[start], len);
    str [len] = 0; // zero termination for string
    return TRUE;
}

void DelimTextBuffer :: Print (ostream & stream) const
{
  stream << "Buffer has max characters "<<MaxBytes;
  stream << " and Buffer Size "<<BufferSize<<endl;
}

// Protected members

int DelimTextBuffer :: Init (char delim, int maxBytes)
 // construct with a maximum of maxFields
{
  Delim = delim;
  DelimStr[0] = Delim;
  DelimStr[1] = 0;
  if (maxBytes < 0) maxBytes = 0;
  MaxBytes = maxBytes;
  Buffer = new char[MaxBytes];
  BufferSize = 0;
  return 1;
}

int DelimTextBuffer::DRead (istream & stream, int recref)
// read specified record
{

	stream . seekg (recref, ios::beg);
	if (stream . tellg () != recref)
	    return -1;
	Clear();
	stream . read ((char*)&BufferSize, sizeof(BufferSize));
    if (BufferSize > MaxBytes)
      return FALSE; // buffer overflow
    stream . read (Buffer, BufferSize);
    return stream . good ();


    //return Read (stream);
}

